/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.classpath;

import b.a.lb;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ui.configuration.ModuleConfigurationState;
import com.intellij.openapi.roots.ui.configuration.classpath.ClasspathPanelImpl;
import com.intellij.openapi.roots.ui.configuration.classpath.ClasspathTableItem;
import com.intellij.openapi.roots.ui.configuration.classpath.InvalidJdkItem;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ItemRemovable;
import com.intellij.util.ui.ListTableModel;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import org.jetbrains.annotations.Nullable;

class ClasspathTableModel
extends ListTableModel<ClasspathTableItem<?>>
implements ItemRemovable {
    static final String EXPORT_COLUMN_NAME;
    private static final ColumnInfo<ClasspathTableItem<?>, Boolean> e;
    private static final String f;
    private static final Comparator<DependencyScope> c;
    private static final Comparator<ClasspathTableItem<?>> g;
    private static final ColumnInfo<ClasspathTableItem<?>, DependencyScope> d;
    public static final int EXPORT_COLUMN = 0;
    public static final int ITEM_COLUMN = 1;
    public static final int SCOPE_COLUMN = 2;
    private final ModuleConfigurationState a;
    private final StructureConfigurableContext b;

    ClasspathTableModel(ModuleConfigurationState state, StructureConfigurableContext context) {
        super(new ColumnInfo[]{e, new ClasspathTableItemClasspathColumnInfo(context), d});
        this.a = state;
        this.b = context;
        this.init();
    }

    public RowSorter.SortKey getDefaultSortKey() {
        return new RowSorter.SortKey(1, SortOrder.UNSORTED);
    }

    private ModifiableRootModel a() {
        return this.a.getRootModel();
    }

    public void init() {
        OrderEntry[] orderEntryArray = this.a().getOrderEntries();
        boolean bl2 = false;
        ArrayList arrayList = new ArrayList();
        for (OrderEntry orderEntry : orderEntryArray) {
            if (orderEntry instanceof JdkOrderEntry) {
                bl2 = true;
            }
            arrayList.add(ClasspathTableItem.createItem(orderEntry, this.b));
        }
        if (!bl2) {
            arrayList.add(0, new InvalidJdkItem());
        }
        this.setItems(arrayList);
    }

    public void exchangeRows(int idx1, int idx2) {
        super.exchangeRows(idx1, idx2);
        List<OrderEntry> list2 = this.b();
        this.a.getRootModel().rearrangeOrderEntries(list2.toArray(OrderEntry.EMPTY_ARRAY));
    }

    public void clear() {
        this.setItems(Collections.emptyList());
    }

    private List<OrderEntry> b() {
        int n2 = this.getRowCount();
        ArrayList<OrderEntry> arrayList = new ArrayList<OrderEntry>(n2);
        for (int i10 = 0; i10 < n2; ++i10) {
            Object t2 = ((ClasspathTableItem)this.getItem(i10)).getEntry();
            if (t2 == null) continue;
            arrayList.add((OrderEntry)t2);
        }
        return arrayList;
    }

    static {
        long l2 = lb.a(5006540626807161507L, 5062523464505602326L, MethodHandles.lookup().lookupClass()).a(19387887645171L) ^ 0x98C2935E348L;
        EXPORT_COLUMN_NAME = ProjectBundle.message((String)"modules.order.export.export.column", (Object[])new Object[0]);
        e = new ColumnInfo<ClasspathTableItem<?>, Boolean>(EXPORT_COLUMN_NAME){

            @Nullable
            public Boolean valueOf(ClasspathTableItem<?> item) {
                return item.isExported();
            }

            public void setValue(ClasspathTableItem<?> item, Boolean value) {
                item.setExported(value);
            }

            public boolean isCellEditable(ClasspathTableItem<?> item) {
                return item.isExportable();
            }

            public Class getColumnClass() {
                return Boolean.class;
            }
        };
        f = ProjectBundle.message((String)"modules.order.export.scope.column", (Object[])new Object[0]);
        c = (dependencyScope, dependencyScope2) -> dependencyScope.getDisplayName().compareToIgnoreCase(dependencyScope2.getDisplayName());
        g = (classpathTableItem, classpathTableItem2) -> Comparing.compare((Object)classpathTableItem.getScope(), (Object)classpathTableItem2.getScope(), c);
        d = new ColumnInfo<ClasspathTableItem<?>, DependencyScope>(f){

            @Nullable
            public DependencyScope valueOf(ClasspathTableItem<?> item) {
                return item.getScope();
            }

            public void setValue(ClasspathTableItem<?> item, DependencyScope value) {
                item.setScope(value);
            }

            public boolean isCellEditable(ClasspathTableItem<?> item) {
                return item.isExportable();
            }

            public Class getColumnClass() {
                return DependencyScope.class;
            }

            @Nullable
            public Comparator<ClasspathTableItem<?>> getComparator() {
                return g;
            }
        };
    }

    private static class ClasspathTableItemClasspathColumnInfo
    extends ColumnInfo<ClasspathTableItem<?>, ClasspathTableItem<?>> {
        private final Comparator<ClasspathTableItem<?>> a = (classpathTableItem, classpathTableItem2) -> {
            String string = ClasspathPanelImpl.getCellAppearance(classpathTableItem, context, false).getText();
            String string2 = ClasspathPanelImpl.getCellAppearance(classpathTableItem2, context, false).getText();
            return string.compareToIgnoreCase(string2);
        };

        ClasspathTableItemClasspathColumnInfo(StructureConfigurableContext context) {
            super("");
        }

        @Nullable
        public Comparator<ClasspathTableItem<?>> getComparator() {
            return this.a;
        }

        @Nullable
        public ClasspathTableItem<?> valueOf(ClasspathTableItem<?> item) {
            return item;
        }

        public Class getColumnClass() {
            return ClasspathTableItem.class;
        }
    }
}

