/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot.daemon;

import b.a.lb;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectConfigurationProblems;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureDaemonAnalyzerListener;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElementUsage;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemDescription;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemsHolderImpl;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureValidator;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.util.Alarm;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectStructureDaemonAnalyzer
implements Disposable {
    private static final Logger i;
    private final Map<ProjectStructureElement, ProjectStructureProblemsHolderImpl> f;
    private final MultiValuesMap<ProjectStructureElement, ProjectStructureElementUsage> a;
    private final MultiValuesMap<ProjectStructureElement, ProjectStructureElementUsage> e;
    private final Set<ProjectStructureElement> h;
    private final Set<ProjectStructureElement> c;
    private final Map<ProjectStructureElement, ProjectStructureProblemDescription> d;
    private final MergingUpdateQueue b;
    private final MergingUpdateQueue j;
    private final EventDispatcher<ProjectStructureDaemonAnalyzerListener> k;
    private final AtomicBoolean g;
    private final ProjectConfigurationProblems l;
    private static final long m;

    public ProjectStructureDaemonAnalyzer(StructureConfigurableContext context) {
        long l2 = m ^ 0x46FB69B9BC1BL;
        this.f = new HashMap<ProjectStructureElement, ProjectStructureProblemsHolderImpl>();
        this.a = new MultiValuesMap();
        this.e = new MultiValuesMap();
        this.h = new HashSet<ProjectStructureElement>();
        this.c = new HashSet<ProjectStructureElement>();
        this.d = new HashMap<ProjectStructureElement, ProjectStructureProblemDescription>();
        this.k = EventDispatcher.create(ProjectStructureDaemonAnalyzerListener.class);
        this.g = new AtomicBoolean(false);
        Disposer.register((Disposable)context, (Disposable)this);
        this.l = new ProjectConfigurationProblems(this, context);
        this.b = new MergingUpdateQueue("Project Structure Daemon Analyzer", 300, false, null, (Disposable)this, null, Alarm.ThreadToUse.POOLED_THREAD);
        this.j = new MergingUpdateQueue("Project Structure Analysis Results Updater", 300, false, MergingUpdateQueue.ANY_COMPONENT, (Disposable)this, null, Alarm.ThreadToUse.SWING_THREAD);
    }

    private void b(ProjectStructureElement projectStructureElement, boolean bl2, boolean bl3) {
        if (this.g.get()) {
            return;
        }
        if (bl2) {
            this.a(projectStructureElement);
        }
        if (bl3) {
            this.c(projectStructureElement);
        }
    }

    private void a(ProjectStructureElement projectStructureElement) {
        ProjectStructureProblemsHolderImpl projectStructureProblemsHolderImpl = new ProjectStructureProblemsHolderImpl();
        ReadAction.run(() -> {
            long l2 = m ^ 0x40E9F73C66B4L;
            if (this.g.get()) {
                return;
            }
            if (i.isDebugEnabled()) {
                i.debug("checking " + projectStructureElement);
            }
            ProjectStructureValidator.check(projectStructureElement, projectStructureProblemsHolderImpl);
        });
        this.j.queue((Update)new ProblemsComputedUpdate(this, projectStructureElement, projectStructureProblemsHolderImpl));
    }

    private void c(ProjectStructureElement projectStructureElement) {
        List list2 = (List)ReadAction.compute(() -> {
            long l2 = m ^ 0x2A2790C09DCAL;
            if (this.g.get()) {
                return null;
            }
            if (i.isDebugEnabled()) {
                i.debug("collecting usages in " + projectStructureElement);
            }
            return ProjectStructureDaemonAnalyzer.b(projectStructureElement);
        });
        if (list2 != null) {
            this.j.queue((Update)new UsagesCollectedUpdate(this, projectStructureElement, list2));
        }
    }

    private static List<ProjectStructureElementUsage> b(ProjectStructureElement projectStructureElement) {
        return ProjectStructureValidator.getUsagesInElement(projectStructureElement);
    }

    private void a(ProjectStructureElement projectStructureElement, List<? extends ProjectStructureElementUsage> list2) {
        this.e(projectStructureElement);
        for (ProjectStructureElementUsage projectStructureElementUsage : list2) {
            this.a(projectStructureElementUsage);
        }
        this.h.remove(projectStructureElement);
        this.j.queue((Update)new ReportUnusedElementsUpdate(this));
    }

    public void queueUpdate(@NotNull ProjectStructureElement element) {
        if (element == null) {
            ProjectStructureDaemonAnalyzer.a(0);
        }
        this.a(element, true, true);
    }

    private void a(@NotNull ProjectStructureElement projectStructureElement, boolean bl2, boolean bl3) {
        long l2 = m ^ 0x5C5A023E55F1L;
        if (projectStructureElement == null) {
            ProjectStructureDaemonAnalyzer.a(1);
        }
        if (i.isDebugEnabled()) {
            i.debug("start " + (bl2 ? "checking " : "") + (bl3 ? "collecting usages " : "") + "for " + projectStructureElement);
        }
        if (bl3) {
            this.h.add(projectStructureElement);
        }
        if (projectStructureElement.shouldShowWarningIfUnused()) {
            this.c.add(projectStructureElement);
        }
        this.b.queue((Update)new AnalyzeElementUpdate(projectStructureElement, bl2, bl3));
    }

    public void removeElement(ProjectStructureElement element) {
        this.removeElements(Collections.singletonList(element));
    }

    public void removeElements(@NotNull List<? extends ProjectStructureElement> elements) {
        if (elements == null) {
            ProjectStructureDaemonAnalyzer.a(2);
        }
        this.h.removeAll(elements);
        this.c.removeAll(elements);
        for (ProjectStructureElement projectStructureElement : elements) {
            this.d.remove(projectStructureElement);
            this.f.remove(projectStructureElement);
            Collection collection = this.a.removeAll((Object)projectStructureElement);
            if (collection != null) {
                for (ProjectStructureElementUsage projectStructureElementUsage : collection) {
                    this.f.remove(projectStructureElementUsage.getContainingElement());
                }
            }
            this.e(projectStructureElement);
            ((ProjectStructureDaemonAnalyzerListener)this.k.getMulticaster()).problemsChanged(projectStructureElement);
        }
        this.j.queue((Update)new ReportUnusedElementsUpdate(this));
    }

    private void a() {
        if (!this.h.isEmpty()) {
            return;
        }
        for (ProjectStructureElement projectStructureElement : this.c) {
            Collection collection = this.a.get((Object)projectStructureElement);
            ProjectStructureProblemDescription projectStructureProblemDescription = collection == null || collection.isEmpty() ? projectStructureElement.createUnusedElementWarning() : null;
            ProjectStructureProblemDescription projectStructureProblemDescription2 = this.d.put(projectStructureElement, projectStructureProblemDescription);
            ProjectStructureProblemsHolderImpl projectStructureProblemsHolderImpl = this.f.get(projectStructureElement);
            if (projectStructureProblemsHolderImpl == null) {
                projectStructureProblemsHolderImpl = new ProjectStructureProblemsHolderImpl();
                this.f.put(projectStructureElement, projectStructureProblemsHolderImpl);
            }
            if (projectStructureProblemDescription2 != null) {
                projectStructureProblemsHolderImpl.removeProblem(projectStructureProblemDescription2);
            }
            if (projectStructureProblemDescription != null) {
                projectStructureProblemsHolderImpl.registerProblem(projectStructureProblemDescription);
            }
            if (projectStructureProblemDescription2 == null && projectStructureProblemDescription == null) continue;
            ((ProjectStructureDaemonAnalyzerListener)this.k.getMulticaster()).problemsChanged(projectStructureElement);
        }
    }

    private void e(ProjectStructureElement projectStructureElement) {
        Collection collection = this.e.removeAll((Object)projectStructureElement);
        if (collection != null) {
            for (ProjectStructureElementUsage projectStructureElementUsage : collection) {
                this.a.remove((Object)projectStructureElementUsage.getSourceElement(), (Object)projectStructureElementUsage);
            }
        }
    }

    private void a(@NotNull ProjectStructureElementUsage projectStructureElementUsage) {
        if (projectStructureElementUsage == null) {
            ProjectStructureDaemonAnalyzer.a(3);
        }
        this.a.put((Object)projectStructureElementUsage.getSourceElement(), (Object)projectStructureElementUsage);
        this.e.put((Object)projectStructureElementUsage.getContainingElement(), (Object)projectStructureElementUsage);
    }

    public void stop() {
        long l2 = m ^ 0x790ADFCB02E3L;
        i.debug("analyzer stopped");
        this.g.set(true);
        this.b.cancelAllUpdates();
        this.j.cancelAllUpdates();
        this.clearCaches();
        this.b.deactivate();
        this.j.deactivate();
    }

    public void clearCaches() {
        long l2 = m ^ 0x72AF8988A738L;
        i.debug("clear caches");
        this.f.clear();
    }

    public void queueUpdateForAllElementsWithErrors() {
        long l2 = m ^ 0x50F3278C7949L;
        ArrayList<ProjectStructureElement> arrayList = new ArrayList<ProjectStructureElement>();
        for (Map.Entry<ProjectStructureElement, ProjectStructureProblemsHolderImpl> entry : this.f.entrySet()) {
            if (!entry.getValue().containsProblems()) continue;
            arrayList.add(entry.getKey());
        }
        this.f.clear();
        i.debug("Adding to queue updates for " + arrayList.size() + " problematic elements");
        for (ProjectStructureElement projectStructureElement : arrayList) {
            this.queueUpdate(projectStructureElement);
        }
    }

    public void dispose() {
        this.g.set(true);
        this.b.cancelAllUpdates();
        this.j.cancelAllUpdates();
    }

    @Nullable
    public ProjectStructureProblemsHolderImpl getProblemsHolder(ProjectStructureElement element) {
        return this.f.get(element);
    }

    public Collection<ProjectStructureElementUsage> getUsages(ProjectStructureElement selected) {
        ProjectStructureElement[] projectStructureElementArray;
        for (ProjectStructureElement projectStructureElement : projectStructureElementArray = this.h.toArray(new ProjectStructureElement[0])) {
            this.a(projectStructureElement, ProjectStructureDaemonAnalyzer.b(projectStructureElement));
        }
        List<ProjectStructureElementUsage> list2 = this.a.get((Object)selected);
        return list2 != null ? list2 : Collections.emptyList();
    }

    public void addListener(ProjectStructureDaemonAnalyzerListener listener) {
        long l2 = m ^ 0x28F17A2FD868L;
        i.debug("listener added " + listener);
        this.k.addListener((EventListener)listener);
    }

    public void reset() {
        long l2 = m ^ 0x506DB1ACB280L;
        i.debug("analyzer started");
        this.b.activate();
        this.j.activate();
        this.b.queue(new Update("reset"){

            public void run() {
                ProjectStructureDaemonAnalyzer.this.g.set(false);
            }
        });
    }

    public void clear() {
        this.d.clear();
        this.c.clear();
        this.a.clear();
        this.e.clear();
        this.h.clear();
        this.l.clearProblems();
    }

    static {
        m = lb.a(4953004411823635736L, 21397677629542245L, MethodHandles.lookup().lookupClass()).a(239453817689139L);
        long l2 = m ^ 0x2310A791315EL;
        i = Logger.getInstance((String)"#com.intellij.openapi.roots.ui.configuration.projectRoot.validation.ProjectStructureDaemonAnalyzer");
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = m ^ 0x2B597127E3D0L;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/ProjectStructureDaemonAnalyzer";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "queueUpdate";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "removeElements";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addUsage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class ReportUnusedElementsUpdate
    extends Update {
        final /* synthetic */ ProjectStructureDaemonAnalyzer this$0;
        private static final long a = lb.a(-6701666474173417098L, 4562990859749857978L, MethodHandles.lookup().lookupClass()).a(214984552666552L);

        private ReportUnusedElementsUpdate(ProjectStructureDaemonAnalyzer projectStructureDaemonAnalyzer) {
            long l2 = a ^ 0x237545B17598L;
            this.this$0 = projectStructureDaemonAnalyzer;
            super((Object)"unused elements");
        }

        public void run() {
            this.this$0.a();
        }
    }

    private class ProblemsComputedUpdate
    extends Update {
        private final ProjectStructureElement a;
        private final ProjectStructureProblemsHolderImpl c;
        private final Object[] b;
        final /* synthetic */ ProjectStructureDaemonAnalyzer this$0;
        private static final long d = lb.a(4435019383663738519L, -9001524143189425786L, MethodHandles.lookup().lookupClass()).a(182515303002813L);

        ProblemsComputedUpdate(ProjectStructureDaemonAnalyzer projectStructureDaemonAnalyzer, ProjectStructureElement element, ProjectStructureProblemsHolderImpl problemsHolder) {
            long l2 = d ^ 0x48C443759ED7L;
            this.this$0 = projectStructureDaemonAnalyzer;
            super((Object)element);
            this.a = element;
            this.c = problemsHolder;
            this.b = new Object[]{element, "problems computed"};
        }

        @NotNull
        public Object[] getEqualityObjects() {
            if (this.b == null) {
                ProblemsComputedUpdate.a(0);
            }
            return this.b;
        }

        public void run() {
            ProjectStructureProblemDescription projectStructureProblemDescription;
            long l2 = d ^ 0x45D86E2E19L;
            if (this.this$0.g.get()) {
                return;
            }
            if (i.isDebugEnabled()) {
                i.debug("updating problems for " + this.a);
            }
            if ((projectStructureProblemDescription = (ProjectStructureProblemDescription)this.this$0.d.get(this.a)) != null) {
                this.c.registerProblem(projectStructureProblemDescription);
            }
            this.this$0.f.put(this.a, this.c);
            ((ProjectStructureDaemonAnalyzerListener)this.this$0.k.getMulticaster()).problemsChanged(this.a);
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = d ^ 0x1D6A142E3FFFL;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/ProjectStructureDaemonAnalyzer$ProblemsComputedUpdate", "getEqualityObjects"));
        }
    }

    private class UsagesCollectedUpdate
    extends Update {
        private final ProjectStructureElement a;
        private final List<? extends ProjectStructureElementUsage> b;
        private final Object[] c;
        final /* synthetic */ ProjectStructureDaemonAnalyzer this$0;
        private static final long d = lb.a(7443758032340595518L, 558846285711122430L, MethodHandles.lookup().lookupClass()).a(30804768360647L);

        UsagesCollectedUpdate(ProjectStructureDaemonAnalyzer projectStructureDaemonAnalyzer, ProjectStructureElement element, List<? extends ProjectStructureElementUsage> usages) {
            long l2 = d ^ 0xBF8D75E539EL;
            this.this$0 = projectStructureDaemonAnalyzer;
            super((Object)element);
            this.a = element;
            this.b = usages;
            this.c = new Object[]{element, "usages collected"};
        }

        @NotNull
        public Object[] getEqualityObjects() {
            if (this.c == null) {
                UsagesCollectedUpdate.a(0);
            }
            return this.c;
        }

        public void run() {
            long l2 = d ^ 0x49CD34F34D1AL;
            if (this.this$0.g.get()) {
                return;
            }
            if (i.isDebugEnabled()) {
                i.debug("updating usages for " + this.a);
            }
            this.this$0.a(this.a, this.b);
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = d ^ 0x2DADBBF2117L;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/ProjectStructureDaemonAnalyzer$UsagesCollectedUpdate", "getEqualityObjects"));
        }
    }

    private class AnalyzeElementUpdate
    extends Update {
        private final ProjectStructureElement d;
        private final boolean a;
        private final boolean c;
        private final Object[] b;
        private static final long e = lb.a(2509765533909040600L, 1250630191352690962L, MethodHandles.lookup().lookupClass()).a(153381698027458L);

        AnalyzeElementUpdate(ProjectStructureElement element, boolean check, boolean collectUsages) {
            super((Object)element);
            this.d = element;
            this.a = check;
            this.c = collectUsages;
            this.b = new Object[]{this.d, this.a, this.c};
        }

        public boolean canEat(Update update) {
            if (!(update instanceof AnalyzeElementUpdate)) {
                return false;
            }
            AnalyzeElementUpdate analyzeElementUpdate = (AnalyzeElementUpdate)update;
            return !(!this.d.equals(analyzeElementUpdate.d) || analyzeElementUpdate.a && !this.a || analyzeElementUpdate.c && !this.c);
        }

        @NotNull
        public Object[] getEqualityObjects() {
            if (this.b == null) {
                AnalyzeElementUpdate.a(0);
            }
            return this.b;
        }

        public void run() {
            try {
                ProjectStructureDaemonAnalyzer.this.b(this.d, this.a, this.c);
            }
            catch (Throwable throwable) {
                i.error(throwable);
            }
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = e ^ 0x1CD15384AEC0L;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/ProjectStructureDaemonAnalyzer$AnalyzeElementUpdate", "getEqualityObjects"));
        }
    }
}

