/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.artifacts;

import b.a.lb;
import com.intellij.CommonBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.RootModelProvider;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.ArtifactTemplate;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.ArtifactRootElement;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.artifacts.JarArtifactFromModulesDialog;
import com.intellij.packaging.impl.artifacts.JarArtifactType;
import com.intellij.packaging.impl.artifacts.PlainArtifactType;
import com.intellij.packaging.impl.elements.LibraryPackagingElement;
import com.intellij.packaging.impl.elements.ManifestFileUtil;
import com.intellij.packaging.impl.elements.ProductionModuleOutputElementType;
import com.intellij.packaging.impl.elements.TestModuleOutputElementType;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import gnu.trove.THashSet;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class JarFromModulesTemplate
extends ArtifactTemplate {
    private static final Logger a;
    private final PackagingElementResolvingContext b;
    private static final long c;

    public JarFromModulesTemplate(PackagingElementResolvingContext context) {
        this.b = context;
    }

    public ArtifactTemplate.NewArtifactConfiguration createArtifact() {
        JarArtifactFromModulesDialog jarArtifactFromModulesDialog = new JarArtifactFromModulesDialog(this.b);
        if (!jarArtifactFromModulesDialog.showAndGet()) {
            return null;
        }
        return this.doCreateArtifact(jarArtifactFromModulesDialog.getSelectedModules(), jarArtifactFromModulesDialog.getMainClassName(), jarArtifactFromModulesDialog.getDirectoryForManifest(), jarArtifactFromModulesDialog.isExtractLibrariesToJar(), jarArtifactFromModulesDialog.isIncludeTests());
    }

    @Nullable
    public ArtifactTemplate.NewArtifactConfiguration doCreateArtifact(Module[] modules, String mainClassName, final String directoryForManifest, boolean extractLibrariesToJar, boolean includeTests) {
        String string;
        long l2 = c ^ 0x7F49E3FFA0B9L;
        VirtualFile virtualFile = null;
        Project project2 = this.b.getProject();
        if (mainClassName != null && !mainClassName.isEmpty() || !extractLibrariesToJar) {
            try {
                string = (VirtualFile)ApplicationManager.getApplication().runWriteAction((ThrowableComputable)new ThrowableComputable<VirtualFile, IOException>(){

                    public VirtualFile compute() throws IOException {
                        return VfsUtil.createDirectoryIfMissing((String)directoryForManifest);
                    }
                });
            }
            catch (IOException iOException) {
                a.info((Throwable)iOException);
                Messages.showErrorDialog((Project)project2, (String)("Cannot create directory '" + directoryForManifest + "': " + iOException.getMessage()), (String)CommonBundle.getErrorTitle());
                return null;
            }
            if (string == null) {
                return null;
            }
            virtualFile = ManifestFileUtil.createManifestFile((VirtualFile)string, project2);
            if (virtualFile == null) {
                return null;
            }
            ManifestFileUtil.updateManifest(virtualFile, mainClassName, null, true);
        }
        string = modules.length == 1 ? modules[0].getName() : project2.getName();
        PackagingElementFactory packagingElementFactory = PackagingElementFactory.getInstance();
        CompositePackagingElement compositePackagingElement = packagingElementFactory.createArchive(ArtifactUtil.suggestArtifactFileName(string) + ".jar");
        OrderEnumerator orderEnumerator = ProjectRootManager.getInstance((Project)project2).orderEntries(Arrays.asList(modules));
        THashSet tHashSet = new THashSet();
        if (!includeTests) {
            orderEnumerator = orderEnumerator.productionOnly();
        }
        ModulesProvider modulesProvider = this.b.getModulesProvider();
        OrderEnumerator orderEnumerator2 = orderEnumerator.using((RootModelProvider)modulesProvider).withoutSdk().runtimeOnly().recursively();
        orderEnumerator2.forEachLibrary((Processor)new CommonProcessors.CollectProcessor((Collection)tHashSet));
        orderEnumerator2.forEachModule(module2 -> {
            if (ProductionModuleOutputElementType.ELEMENT_TYPE.isSuitableModule(modulesProvider, (Module)module2)) {
                compositePackagingElement.addOrFindChild(packagingElementFactory.createModuleOutput(module2));
            }
            if (includeTests && TestModuleOutputElementType.ELEMENT_TYPE.isSuitableModule(modulesProvider, (Module)module2)) {
                compositePackagingElement.addOrFindChild(packagingElementFactory.createTestModuleOutput(module2));
            }
            return true;
        });
        JarArtifactType jarArtifactType = JarArtifactType.getInstance();
        if (virtualFile != null && !virtualFile.equals(ManifestFileUtil.findManifestFile(compositePackagingElement, this.b, jarArtifactType))) {
            compositePackagingElement.addFirstChild(packagingElementFactory.createFileCopyWithParentDirectories(virtualFile.getPath(), ManifestFileUtil.MANIFEST_DIR_NAME));
        }
        String string2 = string + ":jar";
        if (extractLibrariesToJar) {
            JarFromModulesTemplate.a(compositePackagingElement, packagingElementFactory, (Set<? extends Library>)tHashSet);
            return new ArtifactTemplate.NewArtifactConfiguration(compositePackagingElement, string2, (ArtifactType)jarArtifactType);
        }
        ArtifactRootElement artifactRootElement = packagingElementFactory.createArtifactRootElement();
        ArrayList<String> arrayList = new ArrayList<String>();
        artifactRootElement.addOrFindChild((PackagingElement)compositePackagingElement);
        this.a((Set<? extends Library>)tHashSet, artifactRootElement, compositePackagingElement, arrayList);
        ManifestFileUtil.updateManifest(virtualFile, mainClassName, arrayList, true);
        return new ArtifactTemplate.NewArtifactConfiguration((CompositePackagingElement)artifactRootElement, string2, (ArtifactType)PlainArtifactType.getInstance());
    }

    private void a(Set<? extends Library> set, ArtifactRootElement<?> artifactRootElement, CompositePackagingElement<?> compositePackagingElement, List<? super String> list2) {
        PackagingElementFactory packagingElementFactory = PackagingElementFactory.getInstance();
        for (Library library : set) {
            if (LibraryPackagingElement.getKindForLibrary(library).containsDirectoriesWithClasses()) {
                for (VirtualFile virtualFile : library.getFiles(OrderRootType.CLASSES)) {
                    if (virtualFile.isInLocalFileSystem()) {
                        compositePackagingElement.addOrFindChild(packagingElementFactory.createDirectoryCopyWithParentDirectories(virtualFile.getPath(), "/"));
                        continue;
                    }
                    PackagingElement packagingElement = packagingElementFactory.createFileCopyWithParentDirectories(VfsUtil.getLocalFile((VirtualFile)virtualFile).getPath(), "/");
                    artifactRootElement.addOrFindChild(packagingElement);
                    list2.addAll(ManifestFileUtil.getClasspathForElements(Collections.singletonList(packagingElement), this.b, PlainArtifactType.getInstance()));
                }
                continue;
            }
            List list3 = packagingElementFactory.createLibraryElements(library);
            list2.addAll(ManifestFileUtil.getClasspathForElements(list3, this.b, PlainArtifactType.getInstance()));
            artifactRootElement.addOrFindChildren((Collection)list3);
        }
    }

    private static void a(CompositePackagingElement<?> compositePackagingElement, PackagingElementFactory packagingElementFactory, Set<? extends Library> set) {
        for (Library library : set) {
            if (LibraryPackagingElement.getKindForLibrary(library).containsJarFiles()) {
                for (VirtualFile virtualFile : library.getFiles(OrderRootType.CLASSES)) {
                    if (virtualFile.isInLocalFileSystem()) {
                        compositePackagingElement.addOrFindChild(packagingElementFactory.createDirectoryCopyWithParentDirectories(virtualFile.getPath(), "/"));
                        continue;
                    }
                    compositePackagingElement.addOrFindChild(packagingElementFactory.createExtractedDirectory(virtualFile));
                }
                continue;
            }
            compositePackagingElement.addOrFindChildren((Collection)packagingElementFactory.createLibraryElements(library));
        }
    }

    public String getPresentableName() {
        long l2 = c ^ 0x2F4783BD9340L;
        return "From modules with dependencies...";
    }

    static {
        c = lb.a(399394320736917933L, -5147227290035831303L, MethodHandles.lookup().lookupClass()).a(27839475721756L);
        long l2 = c ^ 0x70EC00C2C41DL;
        a = Logger.getInstance((String)"#com.intellij.packaging.impl.artifacts.JarFromModulesTemplate");
    }
}

