/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.elements;

import b.a.lb;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.ComplexPackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementOutputKind;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.packaging.impl.elements.DirectoryCopyPackagingElement;
import com.intellij.packaging.impl.elements.FileCopyPackagingElement;
import com.intellij.packaging.impl.elements.LibraryElementType;
import com.intellij.packaging.impl.ui.LibraryElementPresentation;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.PackagingElementPresentation;
import com.intellij.util.PathUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryPackagingElement
extends ComplexPackagingElement<LibraryPackagingElement> {
    @NonNls
    public static final String LIBRARY_NAME_ATTRIBUTE = "name";
    @NonNls
    public static final String MODULE_NAME_ATTRIBUTE = "module-name";
    @NonNls
    public static final String LIBRARY_LEVEL_ATTRIBUTE = "level";
    private String b;
    private String c;
    private String a;
    private static final long d = lb.a(-7816268023023295693L, -7788070289177178287L, MethodHandles.lookup().lookupClass()).a(40316742273150L);

    public LibraryPackagingElement() {
        super((PackagingElementType)LibraryElementType.LIBRARY_ELEMENT_TYPE);
    }

    public LibraryPackagingElement(String level, String libraryName, String moduleName) {
        super((PackagingElementType)LibraryElementType.LIBRARY_ELEMENT_TYPE);
        this.b = level;
        this.c = libraryName;
        this.a = moduleName;
    }

    public List<? extends PackagingElement<?>> getSubstitution(@NotNull PackagingElementResolvingContext context, @NotNull ArtifactType artifactType) {
        Library library;
        if (context == null) {
            LibraryPackagingElement.a(0);
        }
        if (artifactType == null) {
            LibraryPackagingElement.a(1);
        }
        if ((library = this.findLibrary(context)) != null) {
            VirtualFile[] virtualFileArray = library.getFiles(OrderRootType.CLASSES);
            ArrayList<FileCopyPackagingElement> arrayList = new ArrayList<FileCopyPackagingElement>();
            for (VirtualFile virtualFile : virtualFileArray) {
                String string = PathUtil.getLocalPath((VirtualFile)virtualFile);
                if (string == null) continue;
                String string2 = FileUtil.toSystemIndependentName((String)string);
                arrayList.add((FileCopyPackagingElement)(virtualFile.isDirectory() && virtualFile.isInLocalFileSystem() ? new DirectoryCopyPackagingElement(string2) : new FileCopyPackagingElement(string2)));
            }
            return arrayList;
        }
        return null;
    }

    @NotNull
    public PackagingElementOutputKind getFilesKind(PackagingElementResolvingContext context) {
        Library library = this.findLibrary(context);
        PackagingElementOutputKind packagingElementOutputKind = library != null ? LibraryPackagingElement.getKindForLibrary(library) : PackagingElementOutputKind.OTHER;
        if (packagingElementOutputKind == null) {
            LibraryPackagingElement.a(2);
        }
        return packagingElementOutputKind;
    }

    @NotNull
    public PackagingElementPresentation createPresentation(@NotNull ArtifactEditorContext context) {
        if (context == null) {
            LibraryPackagingElement.a(3);
        }
        LibraryElementPresentation libraryElementPresentation = new LibraryElementPresentation(this.c, this.b, this.a, this.findLibrary((PackagingElementResolvingContext)context), context);
        if (libraryElementPresentation == null) {
            LibraryPackagingElement.a(4);
        }
        return libraryElementPresentation;
    }

    public boolean isEqualTo(@NotNull PackagingElement<?> element) {
        if (element == null) {
            LibraryPackagingElement.a(5);
        }
        if (!(element instanceof LibraryPackagingElement)) {
            return false;
        }
        LibraryPackagingElement libraryPackagingElement = (LibraryPackagingElement)element;
        return this.b != null && this.c != null && this.b.equals(libraryPackagingElement.getLevel()) && this.c.equals(libraryPackagingElement.getLibraryName()) && Comparing.equal((String)this.a, (String)libraryPackagingElement.getModuleName());
    }

    public LibraryPackagingElement getState() {
        return this;
    }

    public void loadState(@NotNull LibraryPackagingElement state) {
        if (state == null) {
            LibraryPackagingElement.a(6);
        }
        this.b = state.getLevel();
        this.c = state.getLibraryName();
        this.a = state.getModuleName();
    }

    @Attribute(value="level")
    public String getLevel() {
        return this.b;
    }

    public void setLevel(String level) {
        this.b = level;
    }

    @Attribute(value="name")
    public String getLibraryName() {
        return this.c;
    }

    public void setLibraryName(String libraryName) {
        this.c = libraryName;
    }

    @Attribute(value="module-name")
    public String getModuleName() {
        return this.a;
    }

    public void setModuleName(String moduleName) {
        this.a = moduleName;
    }

    public String toString() {
        long l2 = d ^ 0x25956E4497C9L;
        return "lib:" + this.c + "(" + (this.a != null ? "module " + this.a : this.b) + ")";
    }

    @Nullable
    public Library findLibrary(@NotNull PackagingElementResolvingContext context) {
        if (context == null) {
            LibraryPackagingElement.a(7);
        }
        if (this.a == null) {
            return context.findLibrary(this.b, this.c);
        }
        ModulesProvider modulesProvider = context.getModulesProvider();
        Module module2 = modulesProvider.getModule(this.a);
        if (module2 != null) {
            for (OrderEntry orderEntry : modulesProvider.getRootModel(module2).getOrderEntries()) {
                String string;
                LibraryOrderEntry libraryOrderEntry;
                if (!(orderEntry instanceof LibraryOrderEntry) || !(libraryOrderEntry = (LibraryOrderEntry)orderEntry).isModuleLevel() || (string = libraryOrderEntry.getLibraryName()) == null || !string.equals(this.c)) continue;
                return libraryOrderEntry.getLibrary();
            }
        }
        return null;
    }

    public static PackagingElementOutputKind getKindForLibrary(Library library) {
        boolean bl2 = false;
        boolean bl3 = false;
        for (VirtualFile virtualFile : library.getFiles(OrderRootType.CLASSES)) {
            if (virtualFile.isInLocalFileSystem()) {
                bl2 = true;
                continue;
            }
            bl3 = true;
        }
        return new PackagingElementOutputKind(bl2, bl3);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = d ^ 0x50F2D8796267L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 4: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactType";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/packaging/impl/elements/LibraryPackagingElement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/packaging/impl/elements/LibraryPackagingElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesKind";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createPresentation";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSubstitution";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createPresentation";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isEqualTo";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findLibrary";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

