/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.elements;

import b.a.lb;
import com.intellij.CommonBundle;
import com.intellij.ide.util.ClassFilter;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.compiler.make.ManifestBuilder;
import com.intellij.openapi.deployment.DeploymentUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.artifacts.PackagingElementPath;
import com.intellij.packaging.impl.artifacts.PackagingElementProcessor;
import com.intellij.packaging.impl.elements.ArchivePackagingElement;
import com.intellij.packaging.impl.elements.DirectoryCopyPackagingElement;
import com.intellij.packaging.impl.elements.FileCopyPackagingElement;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.ManifestFileConfiguration;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiMethodUtil;
import com.intellij.util.PathUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ManifestFileUtil {
    private static final Logger a;
    public static final String MANIFEST_PATH = "META-INF/MANIFEST.MF";
    public static final String MANIFEST_FILE_NAME;
    public static final String MANIFEST_DIR_NAME;
    private static final long b;

    private ManifestFileUtil() {
    }

    @Nullable
    public static VirtualFile findManifestFile(@NotNull CompositePackagingElement<?> root2, PackagingElementResolvingContext context, ArtifactType artifactType) {
        long l2 = b ^ 0x4F12693390F7L;
        if (root2 == null) {
            ManifestFileUtil.a(0);
        }
        return ArtifactUtil.findSourceFileByOutputPath(root2, MANIFEST_PATH, context, artifactType);
    }

    @Nullable
    public static VirtualFile suggestManifestFileDirectory(@NotNull CompositePackagingElement<?> root2, PackagingElementResolvingContext context, ArtifactType artifactType) {
        VirtualFile virtualFile;
        if (root2 == null) {
            ManifestFileUtil.a(1);
        }
        if ((virtualFile = ArtifactUtil.findSourceFileByOutputPath(root2, MANIFEST_DIR_NAME, context, artifactType)) != null) {
            return virtualFile;
        }
        final Ref ref = Ref.create(null);
        final Ref ref2 = Ref.create(null);
        ArtifactUtil.processElementsWithSubstitutions(root2.getChildren(), context, artifactType, PackagingElementPath.EMPTY, new PackagingElementProcessor<PackagingElement<?>>(){
            private static final long a = lb.a(4341150904008012124L, 4165423759396679317L, MethodHandles.lookup().lookupClass()).a(80370719404848L);

            @Override
            public boolean process(@NotNull PackagingElement<?> element, @NotNull PackagingElementPath path) {
                VirtualFile virtualFile;
                if (element == null) {
                    1.a(0);
                }
                if (path == null) {
                    1.a(1);
                }
                if (element instanceof FileCopyPackagingElement) {
                    VirtualFile virtualFile2 = ((FileCopyPackagingElement)element).findFile();
                    if (virtualFile2 != null) {
                        ref2.set((Object)virtualFile2);
                    }
                } else if (element instanceof DirectoryCopyPackagingElement && (virtualFile = ((DirectoryCopyPackagingElement)element).findFile()) != null) {
                    ref.set((Object)virtualFile);
                    return false;
                }
                return true;
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                long l2 = a ^ 0x7B44F39649BAL;
                Object[] objectArray2 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "path";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/packaging/impl/elements/ManifestFileUtil$1";
                objectArray[2] = "process";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (!ref.isNull()) {
            return (VirtualFile)ref.get();
        }
        Project project2 = context.getProject();
        return ManifestFileUtil.a(project2, (VirtualFile)ref2.get());
    }

    @Nullable
    public static VirtualFile suggestManifestFileDirectory(@NotNull Project project2, @Nullable Module module2) {
        OrderEnumerator orderEnumerator;
        VirtualFile[] virtualFileArray;
        if (project2 == null) {
            ManifestFileUtil.a(2);
        }
        if ((virtualFileArray = (orderEnumerator = module2 != null ? OrderEnumerator.orderEntries((Module)module2) : OrderEnumerator.orderEntries((Project)project2)).withoutDepModules().withoutLibraries().withoutSdk().productionOnly().sources().getRoots()).length > 0) {
            return virtualFileArray[0];
        }
        return ManifestFileUtil.a(project2, null);
    }

    @Nullable
    private static VirtualFile a(@NotNull Project project2, @Nullable VirtualFile virtualFile) {
        if (project2 == null) {
            ManifestFileUtil.a(3);
        }
        VirtualFile[] virtualFileArray = ProjectRootManager.getInstance((Project)project2).getContentRoots();
        if (virtualFile == null && virtualFileArray.length > 0) {
            return virtualFileArray[0];
        }
        if (virtualFile != null) {
            for (VirtualFile virtualFile2 : virtualFileArray) {
                if (!VfsUtil.isAncestor((VirtualFile)virtualFile2, (VirtualFile)virtualFile, (boolean)false)) continue;
                return virtualFile2;
            }
        }
        return project2.getBaseDir();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Manifest readManifest(@NotNull VirtualFile manifestFile) {
        if (manifestFile == null) {
            ManifestFileUtil.a(4);
        }
        try (InputStream inputStream = manifestFile.getInputStream();){
            Manifest manifest = new Manifest(inputStream);
            return manifest;
        }
        catch (IOException iOException) {
            return new Manifest();
        }
    }

    public static void updateManifest(@NotNull VirtualFile file, @Nullable String mainClass, @Nullable List<String> classpath, boolean replaceValues) {
        if (file == null) {
            ManifestFileUtil.a(5);
        }
        Manifest manifest = ManifestFileUtil.readManifest(file);
        Attributes attributes = manifest.getMainAttributes();
        if (mainClass != null) {
            attributes.put(Attributes.Name.MAIN_CLASS, mainClass);
        } else if (replaceValues) {
            attributes.remove(Attributes.Name.MAIN_CLASS);
        }
        if (classpath != null && !classpath.isEmpty()) {
            List<String> list2;
            if (replaceValues) {
                list2 = classpath;
            } else {
                list2 = new ArrayList<String>();
                String string = (String)attributes.get(Attributes.Name.CLASS_PATH);
                if (!StringUtil.isEmpty((String)string)) {
                    list2.addAll(StringUtil.split((String)string, (String)" "));
                }
                for (String string2 : classpath) {
                    if (list2.contains(string2)) continue;
                    list2.add(string2);
                }
            }
            attributes.put(Attributes.Name.CLASS_PATH, StringUtil.join(list2, (String)" "));
        } else if (replaceValues) {
            attributes.remove(Attributes.Name.CLASS_PATH);
        }
        ManifestBuilder.setVersionAttribute((Attributes)attributes);
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (file == null) {
                ManifestFileUtil.a(17);
            }
            try (OutputStream outputStream = file.getOutputStream(ManifestFileUtil.class);){
                manifest.write(outputStream);
            }
            catch (IOException iOException) {
                a.info((Throwable)iOException);
            }
        });
    }

    @NotNull
    public static ManifestFileConfiguration createManifestFileConfiguration(@NotNull VirtualFile manifestFile) {
        if (manifestFile == null) {
            ManifestFileUtil.a(6);
        }
        String string = manifestFile.getPath();
        Manifest manifest = ManifestFileUtil.readManifest(manifestFile);
        String string2 = manifest.getMainAttributes().getValue(Attributes.Name.MAIN_CLASS);
        String string3 = manifest.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
        ArrayList arrayList = new ArrayList();
        if (string3 != null) {
            arrayList.addAll(StringUtil.split((String)string3, (String)" "));
        }
        ManifestFileConfiguration manifestFileConfiguration = new ManifestFileConfiguration(string, arrayList, string2, manifestFile.isWritable());
        if (manifestFileConfiguration == null) {
            ManifestFileUtil.a(7);
        }
        return manifestFileConfiguration;
    }

    public static List<String> getClasspathForElements(List<? extends PackagingElement<?>> elements, PackagingElementResolvingContext context, ArtifactType artifactType) {
        final ArrayList<String> arrayList = new ArrayList<String>();
        PackagingElementProcessor packagingElementProcessor = new PackagingElementProcessor<PackagingElement<?>>(){
            private static final long a = lb.a(-2400403618008448550L, -4924543502393179194L, MethodHandles.lookup().lookupClass()).a(271308868576713L);

            @Override
            public boolean process(@NotNull PackagingElement<?> element, @NotNull PackagingElementPath path) {
                if (element == null) {
                    2.a(0);
                }
                if (path == null) {
                    2.a(1);
                }
                if (element instanceof FileCopyPackagingElement) {
                    String string = ((FileCopyPackagingElement)element).getOutputFileName();
                    arrayList.add(DeploymentUtil.appendToPath((String)path.getPathString(), (String)string));
                } else if (element instanceof DirectoryCopyPackagingElement) {
                    arrayList.add(path.getPathString());
                } else if (element instanceof ArchivePackagingElement) {
                    String string = ((ArchivePackagingElement)element).getName();
                    arrayList.add(DeploymentUtil.appendToPath((String)path.getPathString(), (String)string));
                }
                return true;
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                long l2 = a ^ 0x6A89CC8D994AL;
                Object[] objectArray2 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "path";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/packaging/impl/elements/ManifestFileUtil$2";
                objectArray[2] = "process";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        for (PackagingElement<?> packagingElement : elements) {
            ArtifactUtil.processPackagingElements(packagingElement, null, packagingElementProcessor, context, true, artifactType);
        }
        return arrayList;
    }

    @Nullable
    public static VirtualFile showDialogAndCreateManifest(ArtifactEditorContext context, CompositePackagingElement<?> element) {
        FileChooserDescriptor fileChooserDescriptor = ManifestFileUtil.createDescriptorForManifestDirectory();
        VirtualFile virtualFile = ManifestFileUtil.suggestManifestFileDirectory(element, (PackagingElementResolvingContext)context, context.getArtifactType());
        VirtualFile virtualFile2 = FileChooser.chooseFile((FileChooserDescriptor)fileChooserDescriptor, (Project)context.getProject(), (VirtualFile)virtualFile);
        if (virtualFile2 == null) {
            return null;
        }
        return ManifestFileUtil.createManifestFile(virtualFile2, context.getProject());
    }

    @Nullable
    public static VirtualFile createManifestFile(@NotNull VirtualFile directory, @NotNull Project project2) {
        if (directory == null) {
            ManifestFileUtil.a(8);
        }
        if (project2 == null) {
            ManifestFileUtil.a(9);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        try {
            return (VirtualFile)WriteAction.compute(() -> {
                VirtualFile virtualFile2;
                if (directory == null) {
                    ManifestFileUtil.a(16);
                }
                if (!(virtualFile2 = directory).getName().equals(MANIFEST_DIR_NAME)) {
                    virtualFile2 = VfsUtil.createDirectoryIfMissing((VirtualFile)virtualFile2, (String)MANIFEST_DIR_NAME);
                }
                VirtualFile virtualFile3 = virtualFile2.createChildData((Object)virtualFile2, MANIFEST_FILE_NAME);
                try (OutputStream outputStream = virtualFile3.getOutputStream((Object)virtualFile2);){
                    Manifest manifest = new Manifest();
                    ManifestBuilder.setVersionAttribute((Attributes)manifest.getMainAttributes());
                    manifest.write(outputStream);
                }
                return virtualFile3;
            });
        }
        catch (IOException iOException) {
            a.info((Throwable)iOException);
            Messages.showErrorDialog((Project)project2, (String)iOException.getMessage(), (String)CommonBundle.getErrorTitle());
            return null;
        }
    }

    public static FileChooserDescriptor createDescriptorForManifestDirectory() {
        long l2 = b ^ 0x6B5584AC69E1L;
        FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        fileChooserDescriptor.setTitle("Select Directory for META-INF/MANIFEST.MF file");
        return fileChooserDescriptor;
    }

    public static void addManifestFileToLayout(@NotNull String path, @NotNull ArtifactEditorContext context, @NotNull CompositePackagingElement<?> element) {
        if (path == null) {
            ManifestFileUtil.a(10);
        }
        if (context == null) {
            ManifestFileUtil.a(11);
        }
        if (element == null) {
            ManifestFileUtil.a(12);
        }
        context.editLayout(context.getArtifact(), () -> {
            VirtualFile virtualFile;
            if (element == null) {
                ManifestFileUtil.a(13);
            }
            if (context == null) {
                ManifestFileUtil.a(14);
            }
            if (path == null) {
                ManifestFileUtil.a(15);
            }
            if ((virtualFile = ManifestFileUtil.findManifestFile(element, (PackagingElementResolvingContext)context, context.getArtifactType())) == null || !FileUtil.pathsEqual((String)virtualFile.getPath(), (String)path)) {
                PackagingElementFactory.getInstance().addFileCopy(element, MANIFEST_DIR_NAME, path, MANIFEST_FILE_NAME);
            }
        });
    }

    @Nullable
    public static PsiClass selectMainClass(Project project2, @Nullable String initialClassName) {
        long l2 = b ^ 0x3BD6152BD307L;
        TreeClassChooserFactory treeClassChooserFactory = TreeClassChooserFactory.getInstance((Project)project2);
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)project2);
        PsiClass psiClass = initialClassName != null ? JavaPsiFacade.getInstance((Project)project2).findClass(initialClassName, globalSearchScope) : null;
        TreeClassChooser treeClassChooser = treeClassChooserFactory.createWithInnerClassesScopeChooser("Select Main Class", globalSearchScope, (ClassFilter)new MainClassFilter(), psiClass);
        treeClassChooser.showDialog();
        return treeClassChooser.getSelected();
    }

    public static void setupMainClassField(final Project project2, final TextFieldWithBrowseButton field) {
        field.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e10) {
                PsiClass psiClass = ManifestFileUtil.selectMainClass(project2, field.getText());
                if (psiClass != null) {
                    field.setText(psiClass.getQualifiedName());
                }
            }
        });
    }

    static {
        b = lb.a(-8921216272913615801L, -4889024688250451214L, MethodHandles.lookup().lookupClass()).a(48069372740233L);
        long l2 = b ^ 0x7E8BFEEC5C17L;
        a = Logger.getInstance((String)"#com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorContextImpl");
        MANIFEST_FILE_NAME = PathUtil.getFileName((String)MANIFEST_PATH);
        MANIFEST_DIR_NAME = PathUtil.getParentPath((String)MANIFEST_PATH);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = b ^ 0xC331B793FFAL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 7: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: 
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manifestFile";
                break;
            }
            case 5: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/packaging/impl/elements/ManifestFileUtil";
                break;
            }
            case 8: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/packaging/impl/elements/ManifestFileUtil";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createManifestFileConfiguration";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findManifestFile";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "suggestManifestFileDirectory";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "suggestBaseDir";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "readManifest";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "updateManifest";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createManifestFileConfiguration";
                break;
            }
            case 7: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createManifestFile";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addManifestFileToLayout";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addManifestFileToLayout$2";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createManifestFile$1";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "lambda$updateManifest$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MainClassFilter
    implements ClassFilter {
        private MainClassFilter() {
        }

        public boolean isAccepted(PsiClass aClass) {
            return (Boolean)ReadAction.compute(() -> PsiMethodUtil.MAIN_CLASS.value((Object)aClass) && PsiMethodUtil.hasMainMethod((PsiClass)aClass));
        }
    }
}

