/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.projectImport;

import b.a.lb;
import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.impl.NewProjectUtil;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.CompilerProjectExtension;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.projectImport.ProjectImportBuilder;
import com.intellij.projectImport.ProjectOpenProcessor;
import com.intellij.util.ObjectUtils;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ProjectOpenProcessorBase<T extends ProjectImportBuilder>
extends ProjectOpenProcessor {
    private final T a;
    private static final long b = lb.a(-4056360514516643954L, 7165578433713902731L, MethodHandles.lookup().lookupClass()).a(127805727885740L);

    protected ProjectOpenProcessorBase(@NotNull T builder) {
        if (builder == null) {
            ProjectOpenProcessorBase.a(0);
        }
        this.a = builder;
    }

    public String getName() {
        return ((ProjectImportBuilder)((Object)this.getBuilder())).getName();
    }

    @Nullable
    public Icon getIcon() {
        return ((ProjectImportBuilder)((Object)this.getBuilder())).getIcon();
    }

    public boolean canOpenProject(VirtualFile file) {
        String[] stringArray = this.getSupportedExtensions();
        if (stringArray != null) {
            if (file.isDirectory()) {
                for (VirtualFile virtualFile : ProjectOpenProcessorBase.a(file)) {
                    if (!ProjectOpenProcessorBase.canOpenFile(virtualFile, stringArray)) continue;
                    return true;
                }
                return false;
            }
            if (ProjectOpenProcessorBase.canOpenFile(file, stringArray)) {
                return true;
            }
        }
        return false;
    }

    @NotNull
    private static VirtualFile[] a(VirtualFile virtualFile) {
        VirtualFile[] virtualFileArray = (VirtualFile[])ObjectUtils.chooseNotNull((Object)virtualFile.getChildren(), (Object)VirtualFile.EMPTY_ARRAY);
        if (virtualFileArray == null) {
            ProjectOpenProcessorBase.a(1);
        }
        return virtualFileArray;
    }

    protected static boolean canOpenFile(VirtualFile file, String[] supported) {
        String string = file.getName();
        for (String string2 : supported) {
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    protected boolean doQuickImport(VirtualFile file, WizardContext wizardContext) {
        return false;
    }

    @NotNull
    public T getBuilder() {
        T t2 = this.a;
        if (t2 == null) {
            ProjectOpenProcessorBase.a(2);
        }
        return t2;
    }

    @Nullable
    public abstract String[] getSupportedExtensions();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Project doOpenProject(@NotNull VirtualFile virtualFile, Project projectToClose, boolean forceOpenInNewFrame) {
        long l2 = b ^ 0xA9EFCC6A0ECL;
        if (virtualFile == null) {
            ProjectOpenProcessorBase.a(3);
        }
        try {
            String string;
            Object object;
            Sdk sdk;
            Project project2;
            ((ProjectImportBuilder)((Object)this.getBuilder())).setUpdate(false);
            WizardContext wizardContext = new WizardContext(null, null);
            if (virtualFile.isDirectory()) {
                project2 = this.getSupportedExtensions();
                sdk = ProjectOpenProcessorBase.a(virtualFile);
                int n2 = ((VirtualFile[])sdk).length;
                for (int i10 = 0; i10 < n2; ++i10) {
                    object = sdk[i10];
                    if (!ProjectOpenProcessorBase.canOpenFile((VirtualFile)object, (String[])project2)) continue;
                    virtualFile = object;
                    break;
                }
            }
            wizardContext.setProjectFileDirectory(virtualFile.getParent().getPath());
            if (!this.doQuickImport(virtualFile, wizardContext)) {
                project2 = null;
                return project2;
            }
            if (wizardContext.getProjectName() == null) {
                if (wizardContext.getProjectStorageFormat() == StorageScheme.DEFAULT) {
                    wizardContext.setProjectName(IdeBundle.message((String)"project.import.default.name", (Object[])new Object[]{this.getName()}) + ".ipr");
                } else {
                    wizardContext.setProjectName(IdeBundle.message((String)"project.import.default.name.dotIdea", (Object[])new Object[]{this.getName()}));
                }
            }
            if ((sdk = ProjectRootManager.getInstance((Project)(project2 = ProjectManager.getInstance().getDefaultProject())).getProjectSdk()) == null) {
                sdk = ProjectJdkTable.getInstance().findMostRecentSdkOfType((SdkTypeId)JavaSdk.getInstance());
            }
            wizardContext.setProjectJdk(sdk);
            String string2 = wizardContext.getProjectFileDirectory() + File.separator + ".idea";
            String string3 = wizardContext.getProjectFileDirectory() + File.separator + wizardContext.getProjectName() + ".ipr";
            object = new File(string2);
            File file = new File(string3);
            String string4 = wizardContext.getProjectStorageFormat() == StorageScheme.DEFAULT ? string3 : ((File)object).getParent();
            boolean bl2 = false;
            boolean bl3 = true;
            if (file.exists() || ((File)object).exists()) {
                if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
                    bl2 = true;
                    bl3 = true;
                } else {
                    if (((File)object).exists()) {
                        string = "an existing project";
                        string4 = ((File)object).getParent();
                    } else {
                        string = "'" + file.getName() + "'";
                        string4 = string3;
                    }
                    int n3 = Messages.showYesNoCancelDialog((Project)projectToClose, (String)IdeBundle.message((String)"project.import.open.existing", (Object[])new Object[]{string, file.getParent(), virtualFile.getName()}), (String)IdeBundle.message((String)"title.open.project", (Object[])new Object[0]), (String)IdeBundle.message((String)"project.import.open.existing.openExisting", (Object[])new Object[0]), (String)IdeBundle.message((String)"project.import.open.existing.reimport", (Object[])new Object[0]), (String)CommonBundle.message((String)"button.cancel", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
                    if (n3 == 2) {
                        Project project3 = null;
                        return project3;
                    }
                    bl2 = n3 == 0;
                    boolean bl4 = bl3 = !bl2;
                }
            }
            if (bl2) {
                try {
                    string = ProjectManagerEx.getInstanceEx().loadProject(string4);
                }
                catch (Exception exception) {
                    Project project4 = null;
                    this.getBuilder().cleanup();
                    return project4;
                }
            } else {
                string = ProjectManagerEx.getInstanceEx().newProject(wizardContext.getProjectName(), string4, true, false);
            }
            if (string == null) {
                Project project5 = null;
                return project5;
            }
            if (bl3) {
                if (!this.getBuilder().validate(projectToClose, (Project)string)) {
                    Project project6 = null;
                    return project6;
                }
                string.save();
                ApplicationManager.getApplication().runWriteAction(() -> ProjectOpenProcessorBase.a(wizardContext, (Project)string));
                ((ProjectImportBuilder)((Object)this.getBuilder())).commit((Project)string, null, ModulesProvider.EMPTY_MODULES_PROVIDER);
            }
            if (!forceOpenInNewFrame) {
                NewProjectUtil.closePreviousProject(projectToClose);
            }
            ProjectUtil.updateLastProjectLocation((String)string4);
            ProjectManagerEx.getInstanceEx().openProject((Project)string);
            String string5 = string;
            return string5;
        }
        finally {
            this.getBuilder().cleanup();
        }
    }

    public static String getUrl(@NonNls String path) {
        try {
            path = FileUtil.resolveShortWindowsName((String)path);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return VfsUtilCore.pathToUrl((String)FileUtil.toSystemIndependentName((String)path));
    }

    private static /* synthetic */ void a(WizardContext wizardContext, Project project2) {
        long l2 = b ^ 0x78DC0C512C3DL;
        Sdk sdk = wizardContext.getProjectJdk();
        if (sdk != null) {
            NewProjectUtil.applyJdkToProject(project2, sdk);
        }
        String string = wizardContext.getProjectFileDirectory();
        String string2 = string + (StringUtil.endsWithChar((CharSequence)string, (char)'/') ? "classes" : "/classes");
        CompilerProjectExtension compilerProjectExtension = CompilerProjectExtension.getInstance((Project)project2);
        if (compilerProjectExtension != null) {
            compilerProjectExtension.setCompilerOutputUrl(ProjectOpenProcessorBase.getUrl(string2));
        }
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = b ^ 0x1A22A3F83B54L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 2: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/projectImport/ProjectOpenProcessorBase";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/projectImport/ProjectOpenProcessorBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileChildren";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuilder";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doOpenProject";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

