/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.mock.MockApplicationEx;
import com.intellij.mock.MockProjectEx;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingManagerImpl;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.UsefulTestCase;
import org.jetbrains.annotations.NotNull;
import org.picocontainer.MutablePicoContainer;

public abstract class PlatformLiteFixture
extends UsefulTestCase {
    protected MockProjectEx myProject;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Extensions.cleanRootArea((Disposable)this.getTestRootDisposable());
    }

    public static MockApplicationEx getApplication() {
        return (MockApplicationEx)ApplicationManager.getApplication();
    }

    public void initApplication() {
        MockApplicationEx instance2 = new MockApplicationEx(this.getTestRootDisposable());
        ApplicationManager.setApplication((Application)instance2, () -> FileTypeManager.getInstance(), (Disposable)this.getTestRootDisposable());
        PlatformLiteFixture.getApplication().registerService(EncodingManager.class, EncodingManagerImpl.class);
    }

    @Override
    protected void tearDown() throws Exception {
        this.myProject = null;
        try {
            super.tearDown();
        }
        finally {
            PlatformLiteFixture.clearFields((Object)this);
        }
    }

    protected <T> void registerExtension(ExtensionPointName<T> extensionPointName, @NotNull T t2) {
        if (t2 == null) {
            PlatformLiteFixture.$$$reportNull$$$0(0);
        }
        this.registerExtension(Extensions.getRootArea(), extensionPointName, t2);
    }

    public <T> void registerExtension(ExtensionsArea area, ExtensionPointName<T> name2, T t2) {
        this.registerExtensionPoint(area, name2, t2.getClass());
        PlatformTestUtil.registerExtension(area, name2, t2, this.getTestRootDisposable());
    }

    protected <T> void registerExtensionPoint(ExtensionPointName<T> extensionPointName, Class<T> aClass) {
        this.registerExtensionPoint(Extensions.getRootArea(), extensionPointName, aClass);
    }

    protected <T> void registerExtensionPoint(ExtensionsArea area, ExtensionPointName<T> extensionPointName, Class<? extends T> aClass) {
        String name2 = extensionPointName.getName();
        if (!area.hasExtensionPoint(name2)) {
            ExtensionPoint.Kind kind = aClass.isInterface() || (aClass.getModifiers() & 0x400) != 0 ? ExtensionPoint.Kind.INTERFACE : ExtensionPoint.Kind.BEAN_CLASS;
            area.registerExtensionPoint(name2, aClass.getName(), kind);
        }
    }

    protected void registerComponentImplementation(MutablePicoContainer container, Class<?> key, Class<?> implementation) {
        container.unregisterComponent(key);
        container.registerComponentImplementation(key, implementation);
    }

    public static <T> T registerComponentInstance(MutablePicoContainer container, Class<T> key, T implementation) {
        Object old = container.getComponentInstance(key);
        container.unregisterComponent(key);
        container.registerComponentInstance(key, implementation);
        return (T)old;
    }

    public static <T> T registerComponentInstance(ComponentManager container, Class<T> key, T implementation) {
        return PlatformLiteFixture.registerComponentInstance((MutablePicoContainer)container.getPicoContainer(), key, implementation);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/testFramework/PlatformLiteFixture", "registerExtension"));
    }
}

