/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Log4jBasedLogger;
import com.intellij.testFramework.LoggedErrorProcessor;
import com.intellij.testFramework.TestLoggerFactory;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestLogger
extends Log4jBasedLogger {
    TestLogger(@NotNull Logger logger) {
        if (logger == null) {
            TestLogger.$$$reportNull$$$0(0);
        }
        super(logger);
    }

    public void warn(String message, @Nullable Throwable t2) {
        t2 = TestLogger.checkException((Throwable)t2);
        LoggedErrorProcessor.getInstance().processWarn(message, t2, this.myLogger);
    }

    public void error(String message, @Nullable Throwable t2, String ... details) {
        if (details == null) {
            TestLogger.$$$reportNull$$$0(1);
        }
        t2 = TestLogger.checkException((Throwable)t2);
        LoggedErrorProcessor.getInstance().processError(message, t2, details, this.myLogger);
    }

    public void debug(@NonNls String message) {
        if (this.isDebugEnabled()) {
            super.debug(message);
            TestLoggerFactory.log(this.myLogger, Level.DEBUG, message, null);
        }
    }

    public void debug(@Nullable Throwable t2) {
        if (this.isDebugEnabled()) {
            super.debug(t2);
            TestLoggerFactory.log(this.myLogger, Level.DEBUG, null, t2);
        }
    }

    public void debug(@NonNls String message, @Nullable Throwable t2) {
        if (this.isDebugEnabled()) {
            super.debug(message, t2);
            TestLoggerFactory.log(this.myLogger, Level.DEBUG, message, t2);
        }
    }

    public void info(@NonNls String message) {
        super.info(message);
        TestLoggerFactory.log(this.myLogger, Level.INFO, message, null);
    }

    public void info(@NonNls String message, @Nullable Throwable t2) {
        super.info(message, t2);
        TestLoggerFactory.log(this.myLogger, Level.INFO, message, t2);
    }

    public void trace(String message) {
        if (this.isTraceEnabled()) {
            super.trace(message);
            TestLoggerFactory.log(this.myLogger, Level.TRACE, message, null);
        }
    }

    public void trace(@Nullable Throwable t2) {
        if (this.isTraceEnabled()) {
            super.trace(t2);
            TestLoggerFactory.log(this.myLogger, Level.TRACE, null, t2);
        }
    }

    public boolean isDebugEnabled() {
        if (ApplicationInfoImpl.isInStressTest()) {
            return super.isDebugEnabled();
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logger";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "details";
                break;
            }
        }
        objectArray2[1] = "com/intellij/testFramework/TestLogger";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "error";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

