/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.concurrency.JobSchedulerImpl;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.testFramework.CpuTimings;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class Timings {
    private static final int IO_PROBES = 42;
    public static final long CPU_TIMING = CpuTimings.calcStableCpuTiming();
    public static final long IO_TIMING;
    public static final long REFERENCE_CPU_TIMING = 200L;
    public static final long REFERENCE_IO_TIMING = 100L;

    public static int adjustAccordingToMySpeed(int value, boolean isParallelizable) {
        return Math.max(1, (int)(1.0 * (double)value * 200.0 / (double)CPU_TIMING) / 8 * (isParallelizable ? JobSchedulerImpl.getJobPoolParallelism() : 1));
    }

    public static String getStatistics() {
        return String.format("CPU=%d (%d%% reference CPU), I/O=%d (%d%% reference IO), %d cores", CPU_TIMING, CPU_TIMING * 100L / 200L, IO_TIMING, IO_TIMING * 100L / 100L, Runtime.getRuntime().availableProcessors());
    }

    static {
        long start = System.currentTimeMillis();
        for (int i10 = 0; i10 < 42; ++i10) {
            try {
                File tempFile = FileUtil.createTempFile((String)"test", (String)("test" + i10));
                try (FileWriter writer = new FileWriter(tempFile);){
                    for (int j10 = 0; j10 < 15; ++j10) {
                        writer.write("test" + j10);
                        writer.flush();
                    }
                }
                var5_5 = null;
                try (FileReader reader = new FileReader(tempFile);){
                    while (reader.read() >= 0) {
                    }
                }
                catch (Throwable throwable) {
                    var5_5 = throwable;
                    throw throwable;
                }
                if (i10 == 41) {
                    var5_5 = null;
                    try (FileOutputStream stream2 = new FileOutputStream(tempFile);){
                        stream2.getFD().sync();
                    }
                    catch (Throwable throwable) {
                        var5_5 = throwable;
                        throw throwable;
                    }
                }
                if (tempFile.delete()) continue;
                throw new IOException("Unable to delete: " + tempFile);
            }
            catch (IOException e10) {
                throw new RuntimeException(e10);
            }
        }
        IO_TIMING = System.currentTimeMillis() - start;
    }
}

