/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.util.text.StringUtil;
import java.util.function.Function;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;

public class TreeTester {
    private final TreeNode myNode;
    private Function<? super TreeNode, String> myPresenter = Object::toString;

    public static TreeTester forTree(JTree tree2) {
        return TreeTester.forNode((TreeNode)tree2.getModel().getRoot());
    }

    public static TreeTester forNode(TreeNode node) {
        return new TreeTester(node);
    }

    private TreeTester(TreeNode node) {
        this.myNode = node;
    }

    public TreeTester withPresenter(Function<? super TreeNode, String> presenter) {
        this.myPresenter = presenter;
        return this;
    }

    @NotNull
    public String constructTextRepresentation() {
        StringBuilder buffer = new StringBuilder();
        this.printSubTree(this.myNode, 0, buffer);
        String string = buffer.toString();
        if (string == null) {
            TreeTester.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void assertStructureEquals(String expected) {
        Assert.assertEquals((Object)expected, (Object)this.constructTextRepresentation());
    }

    private void printSubTree(TreeNode node, int level, StringBuilder result) {
        result.append(StringUtil.repeat((String)" ", (int)level)).append(this.myPresenter.apply(node)).append("\n");
        for (int i10 = 0; i10 < node.getChildCount(); ++i10) {
            this.printSubTree(node.getChildAt(i10), level + 1, result);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/TreeTester", "constructTextRepresentation"));
    }
}

