/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.propertyBased;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.completion.CodeCompletionHandlerBase;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPlainText;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.testFramework.PsiTestUtil;
import com.intellij.testFramework.fixtures.TestLookupElementPresentation;
import com.intellij.testFramework.propertyBased.ActionOnFile;
import com.intellij.testFramework.propertyBased.CompletionPolicy;
import com.intellij.testFramework.propertyBased.MadTestingUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import junit.framework.TestCase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jetCheck.Generator;
import org.jetbrains.jetCheck.ImperativeCommand;

public class InvokeCompletion
extends ActionOnFile {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.testFramework.propertyBased.InvokeCompletion");
    private final CompletionPolicy myPolicy;

    public InvokeCompletion(@NotNull PsiFile file, @NotNull CompletionPolicy policy) {
        if (file == null) {
            InvokeCompletion.$$$reportNull$$$0(0);
        }
        if (policy == null) {
            InvokeCompletion.$$$reportNull$$$0(1);
        }
        super(file);
        this.myPolicy = policy;
    }

    public void performCommand(@NotNull ImperativeCommand.Environment env) {
        if (env == null) {
            InvokeCompletion.$$$reportNull$$$0(2);
        }
        int offset = this.generateDocOffset(env, "Invoke basic completion at offset %s");
        String selectionCharacters = this.myPolicy.getPossibleSelectionCharacters();
        char c10 = selectionCharacters.charAt((Integer)env.generateValue(Generator.integers((int)0, (int)(selectionCharacters.length() - 1)), null));
        this.performActionAt(offset, c10, env);
    }

    private void performActionAt(int offset, char completionChar, ImperativeCommand.Environment env) {
        Project project2 = this.getProject();
        Editor editor = FileEditorManager.getInstance((Project)project2).openTextEditor(new OpenFileDescriptor(project2, this.getVirtualFile(), 0), true);
        assert (editor != null);
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        editor.getCaretModel().moveToOffset(offset);
        CharSequence textBefore = editor.getDocument().getImmutableCharSequence();
        MadTestingUtil.restrictChangesToDocument(editor.getDocument(), () -> {
            Disposable raiseCompletionLimit = Disposer.newDisposable();
            Registry.get((String)"ide.completion.variant.limit").setValue(100000, raiseCompletionLimit);
            try {
                PsiTestUtil.checkPsiStructureWithCommit(this.getFile(), PsiTestUtil::checkStubsMatchText);
                Editor caretEditor = InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit((Editor)editor, (PsiFile)this.getFile());
                this.performCompletion(caretEditor, Objects.requireNonNull(PsiUtilBase.getPsiFileInEditor((Editor)caretEditor, (Project)project2)), completionChar, env);
                PsiTestUtil.checkPsiStructureWithCommit(this.getFile(), PsiTestUtil::checkStubsMatchText);
            }
            catch (Throwable e10) {
                LOG.debug("Text before completion:\n" + textBefore);
                env.logMessage("Error happened, the file's text before invoking printed to the debug log, search for 'Text before completion' there");
                throw e10;
            }
            finally {
                Disposer.dispose((Disposable)raiseCompletionLimit);
                LookupManager.getInstance((Project)project2).hideActiveLookup();
                UIUtil.dispatchAllInvocationEvents();
            }
        });
    }

    private void performCompletion(@NotNull Editor editor, @NotNull PsiFile file, char completionChar, ImperativeCommand.Environment env) {
        if (editor == null) {
            InvokeCompletion.$$$reportNull$$$0(3);
        }
        if (file == null) {
            InvokeCompletion.$$$reportNull$$$0(4);
        }
        int caretOffset = editor.getCaretModel().getOffset();
        PsiElement leaf = file.findElementAt(TargetElementUtil.adjustOffset((PsiFile)file, (Document)this.getDocument(), (int)caretOffset));
        PsiReference ref = TargetElementUtil.findReference((Editor)editor);
        String expectedVariant = leaf == null || leaf instanceof PsiPlainText ? null : this.myPolicy.getExpectedVariant(editor, file, leaf, ref);
        boolean prefixEqualsExpected = this.isPrefixEqualToExpectedVariant(caretOffset, leaf, ref, expectedVariant);
        boolean shouldCheckDuplicates = this.myPolicy.shouldCheckDuplicates(editor, file, leaf);
        long stampBefore = this.getDocument().getModificationStamp();
        new CodeCompletionHandlerBase(CompletionType.BASIC).invokeCompletion(this.getProject(), editor);
        String notFound = ". Please either fix completion so that the variant is suggested, or, if absolutely needed, tweak CompletionPolicy to exclude it.";
        LookupEx lookup = LookupManager.getActiveLookup((Editor)editor);
        if (lookup == null) {
            if (editor.getCaretModel().getOffset() != caretOffset || this.getDocument().getModificationStamp() != stampBefore) {
                env.logMessage("Completion item was auto-inserted");
                return;
            }
            env.logMessage("No lookup");
            if (expectedVariant == null || prefixEqualsExpected) {
                return;
            }
            TestCase.fail((String)("No lookup, but expected '" + expectedVariant + "' among completion variants" + notFound));
        }
        List items = lookup.getItems();
        if (expectedVariant != null) {
            LookupElement sameItem = (LookupElement)ContainerUtil.find((Iterable)items, e10 -> e10.getAllLookupStrings().stream().anyMatch(s2 -> Comparing.equal((String)s2, (String)expectedVariant, (boolean)e10.isCaseSensitive())));
            TestCase.assertNotNull((String)("No variant '" + expectedVariant + "' among " + items + notFound), (Object)sameItem);
        }
        if (shouldCheckDuplicates) {
            InvokeCompletion.checkNoDuplicates(items);
        }
        LookupElement item = (LookupElement)env.generateValue(Generator.sampledFrom((List)items), null);
        env.logMessage("Select '" + item + "' with '" + StringUtil.escapeStringCharacters((String)String.valueOf(completionChar)) + "'");
        lookup.setCurrentItem(item);
        if (LookupEvent.isSpecialCompletionChar((char)completionChar)) {
            ((LookupImpl)lookup).finishLookup(completionChar, item);
        } else {
            EditorActionManager.getInstance().getTypedAction().actionPerformed(editor, completionChar, ((EditorImpl)lookup.getTopLevelEditor()).getDataContext());
        }
    }

    private boolean isPrefixEqualToExpectedVariant(int caretOffset, PsiElement leaf, PsiReference ref, String expectedVariant) {
        if (expectedVariant == null) {
            return false;
        }
        int expectedEnd = ref != null ? ref.getRangeInElement().getEndOffset() + ref.getElement().getTextRange().getStartOffset() : (leaf != null ? leaf.getTextRange().getEndOffset() : 0);
        return expectedEnd == caretOffset && this.getFile().getText().substring(0, caretOffset).endsWith(expectedVariant);
    }

    private static void checkNoDuplicates(List<LookupElement> items) {
        HashSet<List<Object>> presentations = new HashSet<List<Object>>();
        for (LookupElement item : items) {
            List<Object> info;
            TestLookupElementPresentation p2 = TestLookupElementPresentation.renderReal(item);
            if (InvokeCompletion.seemsTruncated(p2.getItemText()) || InvokeCompletion.seemsTruncated(p2.getTailText()) || InvokeCompletion.seemsTruncated(p2.getTypeText()) || presentations.add(info = Arrays.asList(TestLookupElementPresentation.unwrapIcon(p2.getIcon()), p2.getItemText(), p2.getItemTextForeground(), p2.isItemTextBold(), p2.isItemTextUnderlined(), p2.getTailFragments(), p2.getTypeText(), TestLookupElementPresentation.unwrapIcon(p2.getTypeIcon()), p2.isTypeGrayed(), p2.isStrikeout()))) continue;
            TestCase.fail((String)("Duplicate suggestions: " + (Object)((Object)p2)));
        }
    }

    private static boolean seemsTruncated(String text2) {
        return text2 != null && text2.contains("...");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "policy";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/testFramework/propertyBased/InvokeCompletion";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "performCommand";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "performCompletion";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

