/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.propertyBased;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionDelegate;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.QuickFixWrapper;
import com.intellij.codeInspection.ex.ToolsImpl;
import com.intellij.history.Label;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryException;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPlainTextFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.testFramework.RunAll;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.testFramework.fixtures.CodeInsightTestFixture;
import com.intellij.testFramework.propertyBased.ActionOnFile;
import com.intellij.testFramework.propertyBased.CheckPsiReadAccessors;
import com.intellij.testFramework.propertyBased.CheckPsiTextConsistency;
import com.intellij.testFramework.propertyBased.CommitDocumentAction;
import com.intellij.testFramework.propertyBased.DeleteRange;
import com.intellij.testFramework.propertyBased.InsertString;
import com.intellij.testFramework.propertyBased.MadTestingAction;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.SoftFactoryMap;
import com.intellij.util.containers.TreeTraversal;
import com.intellij.util.ui.UIUtil;
import gnu.trove.TObjectLongHashMap;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jetCheck.GenerationEnvironment;
import org.jetbrains.jetCheck.Generator;
import org.jetbrains.jetCheck.PropertyChecker;

public class MadTestingUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.testFramework.propertyBased.MadTestingUtil");
    private static final boolean USE_ROULETTE_WHEEL = true;

    public static void restrictChangesToDocument(Document document, Runnable r2) {
        MadTestingUtil.letSaveAllDocumentsPassIfAny();
        MadTestingUtil.watchDocumentChanges(r2::run, event -> {
            VirtualFile file;
            Document changed = event.getDocument();
            if (changed != document && (file = FileDocumentManager.getInstance().getFile(changed)) != null && file.isInLocalFileSystem()) {
                throw new AssertionError((Object)("Unexpected document change: " + changed));
            }
        });
    }

    private static void letSaveAllDocumentsPassIfAny() {
        UIUtil.dispatchAllInvocationEvents();
    }

    public static void prohibitDocumentChanges(Runnable r2) {
        MadTestingUtil.letSaveAllDocumentsPassIfAny();
        MadTestingUtil.watchDocumentChanges(r2::run, event -> {
            Document changed = event.getDocument();
            VirtualFile file = FileDocumentManager.getInstance().getFile(changed);
            if (file != null && file.isInLocalFileSystem()) {
                throw new AssertionError((Object)("Unexpected document change: " + changed));
            }
        });
    }

    private static <E extends Throwable> void watchDocumentChanges(ThrowableRunnable<E> r2, final Consumer<? super DocumentEvent> eventHandler) throws E {
        Disposable disposable = Disposer.newDisposable();
        EditorFactory.getInstance().getEventMulticaster().addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                eventHandler.accept(event);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/testFramework/propertyBased/MadTestingUtil$1", "documentChanged"));
            }
        }, disposable);
        try {
            r2.run();
        }
        finally {
            Disposer.dispose((Disposable)disposable);
        }
    }

    public static void changeAndRevert(Project project2, Runnable r2) {
        Label label = LocalHistory.getInstance().putUserLabel(project2, "changeAndRevert");
        boolean failed = false;
        try {
            r2.run();
        }
        catch (Throwable e10) {
            failed = true;
            throw e10;
        }
        finally {
            MadTestingUtil.restoreEverything(label, failed, project2);
        }
    }

    private static void restoreEverything(Label label, boolean failed, Project project2) {
        try {
            WriteAction.run(() -> {
                PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project2);
                new RunAll(() -> PostprocessReformattingAspect.getInstance((Project)project2).doPostponedFormatting(), () -> FileEditorManagerEx.getInstanceEx((Project)project2).closeAllFiles(), () -> FileDocumentManager.getInstance().saveAllDocuments(), () -> MadTestingUtil.revertVfs(label, project2), () -> documentManager.commitAllDocuments(), () -> UsefulTestCase.assertEmpty(documentManager.getUncommittedDocuments()), () -> UsefulTestCase.assertEmpty(FileDocumentManager.getInstance().getUnsavedDocuments())).run();
            });
        }
        catch (Throwable e10) {
            if (failed) {
                LOG.info("Exceptions while restoring state", e10);
            }
            throw e10;
        }
    }

    private static void revertVfs(Label label, Project project2) throws LocalHistoryException {
        MadTestingUtil.watchDocumentChanges(() -> label.revert(project2, project2.getBaseDir()), __ -> {
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project2);
            if (documentManager.getUncommittedDocuments().length > 3) {
                documentManager.commitAllDocuments();
            }
        });
    }

    public static void enableAllInspections(Project project2, Disposable disposable, String ... except) {
        InspectionProfileImpl.INIT_INSPECTIONS = true;
        InspectionProfileImpl profile2 = new InspectionProfileImpl("allEnabled");
        profile2.enableAllTools(project2);
        MadTestingUtil.disableInspection(project2, profile2, "HighlightVisitorInternal");
        for (String shortId : except) {
            MadTestingUtil.disableInspection(project2, profile2, shortId);
        }
        ProjectInspectionProfileManager manager = (ProjectInspectionProfileManager)InspectionProjectProfileManager.getInstance((Project)project2);
        manager.addProfile(profile2);
        InspectionProfileImpl prev = manager.getCurrentProfile();
        manager.setCurrentProfile(profile2);
        Disposer.register((Disposable)disposable, () -> {
            InspectionProfileImpl.INIT_INSPECTIONS = false;
            manager.setCurrentProfile(prev);
            manager.deleteProfile(profile2);
        });
    }

    private static void disableInspection(Project project2, InspectionProfileImpl profile2, String shortId) {
        ToolsImpl tools = profile2.getToolsOrNull(shortId, project2);
        if (tools != null) {
            tools.setEnabled(false);
        }
    }

    private static Generator<File> randomFiles(String rootPath, FileFilter fileFilter) {
        return MadTestingUtil.randomFiles(rootPath, fileFilter, true);
    }

    private static Generator<File> randomFiles(final String rootPath, FileFilter fileFilter, boolean useRouletteWheel) {
        FileFilter interestingIdeaFiles = child -> {
            String name2 = child.getName();
            if (name2.startsWith(".")) {
                return false;
            }
            if (child.isDirectory()) {
                return MadTestingUtil.shouldGoInsiderDir(name2);
            }
            return !FileTypeManager.getInstance().getFileTypeByFileName(name2).isBinary() && fileFilter.accept(child) && child.length() < 500000L;
        };
        File root2 = new File(rootPath);
        Function<GenerationEnvironment, File> generator = useRouletteWheel ? new RouletteWheelFileGenerator(root2, interestingIdeaFiles) : new FileGenerator(root2, interestingIdeaFiles);
        return Generator.from((Function)generator).suchThat((Predicate)new Predicate<File>(){

            @Override
            public boolean test(File file) {
                return file != null;
            }

            public String toString() {
                return "can find a file under " + rootPath + " satisfying given filters";
            }
        }).noShrink();
    }

    @NotNull
    public static Supplier<MadTestingAction> actionsOnFileContents(CodeInsightTestFixture fixture, String rootPath, FileFilter fileFilter, Function<? super PsiFile, ? extends Generator<? extends MadTestingAction>> actions) {
        Generator<File> randomFiles = MadTestingUtil.randomFiles(rootPath, fileFilter);
        Supplier<MadTestingAction> supplier = () -> env -> new RunAll(new ThrowableRunnable[0]).append(() -> {
            File ioFile = (File)env.generateValue(randomFiles, "Working with %s");
            VirtualFile vFile = MadTestingUtil.copyFileToProject(ioFile, fixture, rootPath);
            PsiFile psiFile = fixture.getPsiManager().findFile(vFile);
            if (psiFile instanceof PsiBinaryFile || psiFile instanceof PsiPlainTextFile) {
                System.err.println("Can't check " + vFile + " due to incorrect file type: " + psiFile + " of " + psiFile.getClass());
                return;
            }
            env.executeCommands(Generator.from(data -> (MadTestingAction)data.generate((Generator)actions.apply(fixture.getPsiManager().findFile(vFile)))));
        }).append(() -> WriteAction.run(() -> {
            for (VirtualFile file : Objects.requireNonNull(fixture.getTempDirFixture().getFile("")).getChildren()) {
                file.delete((Object)fixture);
            }
        })).append(() -> PsiDocumentManager.getInstance((Project)fixture.getProject()).commitAllDocuments()).append(() -> UIUtil.dispatchAllInvocationEvents()).run();
        if (supplier == null) {
            MadTestingUtil.$$$reportNull$$$0(0);
        }
        return supplier;
    }

    private static boolean shouldGoInsiderDir(@NotNull String name2) {
        if (name2 == null) {
            MadTestingUtil.$$$reportNull$$$0(1);
        }
        return !name2.equals("gen") && !name2.equals("reports") && !name2.equals("android") && !MadTestingUtil.containsBinariesOnly(name2) && !name2.endsWith("system") && !name2.endsWith("config");
    }

    private static boolean containsBinariesOnly(@NotNull String name2) {
        if (name2 == null) {
            MadTestingUtil.$$$reportNull$$$0(2);
        }
        return name2.equals("jdk") || name2.equals("jre") || name2.equals("lib") || name2.equals("bin") || name2.equals("out");
    }

    @NotNull
    private static VirtualFile copyFileToProject(File ioFile, CodeInsightTestFixture fixture, String rootPath) {
        VirtualFile virtualFile;
        try {
            VirtualFile existing;
            String path = FileUtil.getRelativePath((String)FileUtil.toCanonicalPath((String)rootPath), (String)FileUtil.toSystemIndependentName((String)ioFile.getPath()), (char)'/');
            assert (path != null);
            Matcher rootPackageMatcher = Pattern.compile("/com/|/org/").matcher(path);
            if (rootPackageMatcher.find()) {
                path = path.substring(rootPackageMatcher.start() + 1);
            }
            if ((existing = fixture.getTempDirFixture().getFile(path)) != null) {
                WriteAction.run(() -> existing.delete((Object)fixture));
            }
            virtualFile = fixture.addFileToProject(path, FileUtil.loadFile((File)ioFile)).getVirtualFile();
        }
        catch (IOException e10) {
            throw new RuntimeException(e10);
        }
        if (virtualFile == null) {
            MadTestingUtil.$$$reportNull$$$0(3);
        }
        return virtualFile;
    }

    @NotNull
    public static Generator<MadTestingAction> randomEditsWithReparseChecks(@NotNull PsiFile file) {
        if (file == null) {
            MadTestingUtil.$$$reportNull$$$0(4);
        }
        Generator generator = Generator.sampledFrom((Object[])new MadTestingAction[]{new InsertString(file), new DeleteRange(file), new CommitDocumentAction(file), new CheckPsiTextConsistency(file)});
        if (generator == null) {
            MadTestingUtil.$$$reportNull$$$0(5);
        }
        return generator;
    }

    @NotNull
    public static Function<PsiFile, Generator<? extends MadTestingAction>> randomEditsWithPsiAccessorChecks(@NotNull Condition<? super Method> skipCondition) {
        if (skipCondition == null) {
            MadTestingUtil.$$$reportNull$$$0(6);
        }
        Function<PsiFile, Generator<? extends MadTestingAction>> function = file -> {
            if (skipCondition == null) {
                MadTestingUtil.$$$reportNull$$$0(12);
            }
            return Generator.sampledFrom((Object[])new ActionOnFile[]{new InsertString((PsiFile)file), new DeleteRange((PsiFile)file), new CommitDocumentAction((PsiFile)file), new CheckPsiReadAccessors((PsiFile)file, skipCondition)});
        };
        if (function == null) {
            MadTestingUtil.$$$reportNull$$$0(7);
        }
        return function;
    }

    public static boolean isAfterError(PsiFile file, int offset) {
        return SyntaxTraverser.psiTraverser((PsiElement)file).filter(PsiErrorElement.class).find(e10 -> e10.getTextRange().getStartOffset() <= offset) != null;
    }

    public static boolean containsErrorElements(FileViewProvider viewProvider) {
        return ContainerUtil.exists((Iterable)viewProvider.getAllFiles(), file -> SyntaxTraverser.psiTraverser((PsiElement)file).filter(PsiErrorElement.class).isNotEmpty());
    }

    @NotNull
    public static String getPositionDescription(int offset, Document document) {
        int line = document.getLineNumber(offset);
        int start = document.getLineStartOffset(line);
        int end = document.getLineEndOffset(line);
        int column = offset - start;
        String prefix = document.getText(new TextRange(start, offset)).trim();
        if (prefix.length() > 30) {
            prefix = "..." + prefix.substring(prefix.length() - 30);
        }
        String suffix = StringUtil.shortenTextWithEllipsis((String)document.getText(new TextRange(offset, end)), (int)30, (int)0);
        String text2 = prefix + "|" + suffix;
        String string = offset + "(" + line + ":" + column + ") [" + text2 + "]";
        if (string == null) {
            MadTestingUtil.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    static String getIntentionDescription(IntentionAction action) {
        String string = MadTestingUtil.getIntentionDescription(action.getText(), action);
        if (string == null) {
            MadTestingUtil.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    static String getIntentionDescription(String intentionName, IntentionAction action) {
        IntentionAction actual = action;
        while (actual instanceof IntentionActionDelegate) {
            actual = ((IntentionActionDelegate)actual).getDelegate();
        }
        String family = actual.getFamilyName();
        Class<?> aClass = actual.getClass();
        if (actual instanceof QuickFixWrapper) {
            LocalQuickFix fix = ((QuickFixWrapper)actual).getFix();
            family = fix.getFamilyName();
            aClass = fix.getClass();
        }
        String string = "'" + intentionName + "' (family: '" + family + "'; class: '" + aClass.getName() + "')";
        if (string == null) {
            MadTestingUtil.$$$reportNull$$$0(10);
        }
        return string;
    }

    public static void testFileGenerator(File root2, FileFilter filter, int iterationCount, PrintStream out) {
        for (boolean roulette : new boolean[]{true, false}) {
            out.println("Testing " + (roulette ? "roulette" : "plain") + " generator");
            TObjectLongHashMap fileMap = new TObjectLongHashMap();
            Generator<File> generator = MadTestingUtil.randomFiles(root2.getPath(), filter, roulette);
            MadTestingAction action = env -> {
                long lastTime;
                long startTime = lastTime = System.nanoTime();
                for (int iteration = 1; iteration <= iterationCount; ++iteration) {
                    File file = (File)env.generateValue(generator, null);
                    assert (filter.accept(file));
                    if (!fileMap.containsKey((Object)file.getPath())) {
                        fileMap.put((Object)file.getPath(), 1L);
                    } else {
                        fileMap.increment((Object)file.getPath());
                    }
                    long curTime = System.nanoTime();
                    if (iteration <= 10) {
                        out.print("#" + iteration + " = " + (curTime - lastTime) / 1000000L + "ms");
                        if (iteration == 10) {
                            out.println();
                        } else {
                            out.print("; ");
                        }
                        lastTime = curTime;
                    }
                    if (iteration != iterationCount && curTime - lastTime <= TimeUnit.SECONDS.toNanos(5L)) continue;
                    lastTime = curTime;
                    out.println(MadTestingUtil.getHistogramReport((TObjectLongHashMap<String>)fileMap, iteration));
                }
                out.println("Total time: " + (System.nanoTime() - startTime) / 1000000L + "ms");
            };
            PropertyChecker.customized().withIterationCount(1).checkScenarios(() -> action);
        }
    }

    @NotNull
    private static String getHistogramReport(TObjectLongHashMap<String> fileMap, int iteration) {
        long[] stops = new long[]{1L, 2L, 3L, 5L, 10L, 20L, 30L, 50L, 100L, 200L, Long.MAX_VALUE};
        int[] histogram = new int[stops.length];
        fileMap.forEachValue(count -> {
            int pos = Arrays.binarySearch(stops, count);
            if (pos < 0) {
                pos = -pos - 1;
            }
            int n2 = pos;
            histogram[n2] = histogram[n2] + 1;
            return true;
        });
        StringBuilder report = new StringBuilder();
        for (int i10 = 0; i10 < stops.length; ++i10) {
            String range = i10 == 0 || stops[i10 - 1] == stops[i10] - 1L ? String.valueOf(stops[i10]) : stops[i10 - 1] + 1L + (stops[i10] == Long.MAX_VALUE ? "+" : ".." + stops[i10]);
            report.append(String.format(Locale.ENGLISH, "%s: %-5d| ", range, histogram[i10]));
        }
        String string = String.format(Locale.ENGLISH, "#%-5d: sum = %5d [%s]", iteration, Arrays.stream(histogram).sum(), report.toString().replaceFirst("[\\s|]+$", ""));
        if (string == null) {
            MadTestingUtil.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 12: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 12: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/propertyBased/MadTestingUtil";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "skipCondition";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "actionsOnFileContents";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/propertyBased/MadTestingUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "copyFileToProject";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "randomEditsWithReparseChecks";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "randomEditsWithPsiAccessorChecks";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPositionDescription";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getIntentionDescription";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getHistogramReport";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "shouldGoInsiderDir";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "containsBinariesOnly";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "randomEditsWithReparseChecks";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "randomEditsWithPsiAccessorChecks";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$randomEditsWithPsiAccessorChecks$23";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 12: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RouletteWheelFileGenerator
    implements Function<GenerationEnvironment, File> {
        private final File myRoot;
        private final FileFilter myFilter;
        private static final File[] EMPTY_DIRECTORY = new File[0];
        private final SoftFactoryMap<File, File[]> myChildrenCache = new SoftFactoryMap<File, File[]>(){

            protected File[] create(File f10) {
                File[] files = f10.listFiles(child -> myFilter.accept(child) && (child.isFile() || FileGenerator.containsAtLeastOneFileDeep(child)));
                return files != null && files.length == 0 ? EMPTY_DIRECTORY : files;
            }
        };

        private RouletteWheelFileGenerator(File root2, FileFilter filter) {
            this.myRoot = root2;
            this.myFilter = filter;
        }

        @Override
        public File apply(GenerationEnvironment data) {
            return this.generateRandomFile(data, this.myRoot, new HashSet<File>());
        }

        @Nullable
        private File generateRandomFile(GenerationEnvironment data, File file, Set<File> exhausted) {
            File[] children2 = (File[])this.myChildrenCache.get((Object)file);
            if (children2 == null) {
                return file;
            }
            if (children2 == EMPTY_DIRECTORY) {
                return null;
            }
            Arrays.sort(children2, Comparator.comparing(File::getName));
            int[] weights;
            int index;
            while ((index = RouletteWheelFileGenerator.spin(data, weights = Arrays.stream(children2).mapToInt(child -> this.estimateWeight((File)child, exhausted)).toArray())) != -1) {
                File chosen = children2[index];
                File generated = this.generateRandomFile(data, chosen, exhausted);
                if (generated != null) {
                    return generated;
                }
                exhausted.add(chosen);
            }
            return null;
        }

        private static int spin(@NotNull GenerationEnvironment data, @NotNull int[] weights) {
            int totalWeight;
            if (data == null) {
                RouletteWheelFileGenerator.$$$reportNull$$$0(0);
            }
            if (weights == null) {
                RouletteWheelFileGenerator.$$$reportNull$$$0(1);
            }
            if ((totalWeight = Arrays.stream(weights).sum()) == 0) {
                return -1;
            }
            int value = (Integer)data.generate(Generator.integers((int)0, (int)totalWeight));
            for (int i10 = 0; i10 < weights.length; ++i10) {
                if ((value -= weights[i10]) >= 0) continue;
                return i10;
            }
            return -1;
        }

        private int estimateWeight(File file, @NotNull Set<File> exhausted) {
            if (exhausted == null) {
                RouletteWheelFileGenerator.$$$reportNull$$$0(2);
            }
            if (exhausted.contains(file)) {
                return 0;
            }
            File[] children2 = (File[])this.myChildrenCache.get((Object)file);
            if (children2 == null) {
                return 1;
            }
            return Stream.of(children2).mapToInt(f10 -> {
                if (exhausted == null) {
                    RouletteWheelFileGenerator.$$$reportNull$$$0(3);
                }
                return exhausted.contains(f10) ? 0 : (f10.isDirectory() ? 5 : 1);
            }).sum();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "weights";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exhausted";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/testFramework/propertyBased/MadTestingUtil$RouletteWheelFileGenerator";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "spin";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "estimateWeight";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$estimateWeight$1";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class FileGenerator
    implements Function<GenerationEnvironment, File> {
        private static final com.intellij.util.Function<File, JBIterable<File>> FS_TRAVERSAL = TreeTraversal.PRE_ORDER_DFS.traversal(f10 -> f10.isDirectory() ? Arrays.asList((Object[])Objects.requireNonNull(f10.listFiles())) : Collections.emptyList());
        private final File myRoot;
        private final FileFilter myFilter;

        private FileGenerator(File root2, FileFilter filter) {
            this.myRoot = root2;
            this.myFilter = filter;
        }

        @Override
        public File apply(GenerationEnvironment data) {
            return this.generateRandomFile(data, this.myRoot, new HashSet());
        }

        @Nullable
        private File generateRandomFile(GenerationEnvironment data, File file, Set<? super File> exhausted) {
            List<File> toChoose;
            File chosen;
            File generated;
            do {
                File[] children2;
                if ((children2 = file.listFiles(f10 -> !exhausted.contains(f10) && FileGenerator.containsAtLeastOneFileDeep(f10) && this.myFilter.accept(f10))) == null) {
                    return file;
                }
                if (children2.length == 0) {
                    exhausted.add(file);
                    return null;
                }
                toChoose = FileGenerator.preferDirs(data, children2);
                Collections.sort(toChoose, Comparator.comparing(File::getName));
            } while ((generated = this.generateRandomFile(data, chosen = (File)data.generate(Generator.sampledFrom(toChoose)), exhausted)) == null);
            return generated;
        }

        private static boolean containsAtLeastOneFileDeep(File root2) {
            return ((JBIterable)FS_TRAVERSAL.fun((Object)root2)).find(f10 -> f10.isFile()) != null;
        }

        private static List<File> preferDirs(GenerationEnvironment data, File[] children2) {
            ArrayList files = new ArrayList();
            ArrayList<File> dirs = new ArrayList<File>();
            for (File child : children2) {
                (child.isDirectory() ? dirs : files).add(child);
            }
            if (files.isEmpty() || dirs.isEmpty()) {
                return Arrays.asList(children2);
            }
            int ratio = Math.max(100, dirs.size() / files.size());
            return (Integer)data.generate(Generator.integers((int)0, (int)(ratio - 1))) != 0 ? dirs : files;
        }
    }
}

