/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.formatter.comments;

import b.a.lb;
import com.intellij.formatting.FormatterTagHandler;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.webcore.formatter.comments.CommentLineData;
import com.intellij.webcore.formatter.comments.CommentLineDataBuilder;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LineCommentLineDataBuilder
extends CommentLineDataBuilder {
    private final PsiComment d;
    private final IElementType g;
    private static final String h = "//";
    private TextRange c;
    private final CommonCodeStyleSettings.IndentOptions b;
    @Nullable
    private final TextRange e;
    private int f;
    private static final long i = lb.a(8340815714052454770L, -4454466182699047739L, MethodHandles.lookup().lookupClass()).a(146988489472206L);

    public LineCommentLineDataBuilder(@NotNull PsiComment comment, IElementType lineCommentType, @NotNull CommonCodeStyleSettings settings, @Nullable TextRange enabledRange) {
        if (comment == null) {
            LineCommentLineDataBuilder.a(0);
        }
        if (settings == null) {
            LineCommentLineDataBuilder.a(1);
        }
        super(settings.getRootSettings());
        this.d = comment;
        this.g = lineCommentType;
        this.b = settings.getIndentOptions() != null ? settings.getIndentOptions() : new CommonCodeStyleSettings.IndentOptions();
        this.e = enabledRange;
    }

    public boolean isMergedWithPrevious(@NotNull PsiComment comment) {
        if (comment == null) {
            LineCommentLineDataBuilder.a(2);
        }
        if (this.isAfterNonEmptyLine(comment.getNode()) || this.getFormatterTag(comment) != FormatterTagHandler.FormatterTag.NONE) {
            return false;
        }
        PsiElement psiElement = comment.getPrevSibling();
        if (psiElement instanceof PsiWhiteSpace) {
            PsiElement psiElement2 = psiElement;
            if ((psiElement = psiElement.getPrevSibling()) != null && psiElement.getNode().getElementType() == this.g && LineCommentLineDataBuilder.countLineBreaks(psiElement2.getNode()) == 1) {
                int n2;
                if (this.e != null && psiElement.getTextRange().getEndOffset() < this.e.getStartOffset() || psiElement instanceof PsiComment && this.getFormatterTag((PsiComment)psiElement) != FormatterTagHandler.FormatterTag.NONE) {
                    return false;
                }
                int n3 = this.calcBlockLineIndent(comment.getNode());
                return n3 == (n2 = this.calcBlockLineIndent(psiElement.getNode()));
            }
        }
        return false;
    }

    @Override
    public List<CommentLineData> getLines() {
        ArrayList<CommentLineData> arrayList = new ArrayList<CommentLineData>();
        int n2 = this.d.getTextRange().getStartOffset();
        int n3 = this.d.getTextRange().getEndOffset();
        int n4 = this.calcBlockLineIndent(this.d.getNode());
        this.a(arrayList, (PsiElement)this.d, n4, true);
        for (PsiElement psiElement = this.d.getNextSibling(); psiElement != null && (this.e == null || psiElement.getTextRange().getStartOffset() <= this.e.getEndOffset()); psiElement = psiElement.getNextSibling()) {
            if (psiElement.getNode().getElementType() == this.g) {
                int n5;
                if (psiElement instanceof PsiComment && this.getFormatterTag((PsiComment)psiElement) != FormatterTagHandler.FormatterTag.NONE || (n5 = this.calcBlockLineIndent(psiElement.getNode())) != n4) break;
                n3 = psiElement.getTextRange().getEndOffset();
                this.a(arrayList, psiElement, n4, false);
                continue;
            }
            if (!(psiElement instanceof PsiWhiteSpace) || LineCommentLineDataBuilder.countLineBreaks(psiElement.getNode()) > 1) break;
        }
        this.c = new TextRange(n2, n3);
        return arrayList;
    }

    public TextRange getCommentBlockRange() {
        return this.c;
    }

    private void a(List<CommentLineData> list2, @NotNull PsiElement psiElement, int n2, boolean bl2) {
        if (psiElement == null) {
            LineCommentLineDataBuilder.a(3);
        }
        String string = new String(CharArrayUtil.fromSequence((CharSequence)psiElement.getNode().getChars()));
        LineCommentLineData lineCommentLineData = (LineCommentLineData)this.parseLine(string);
        lineCommentLineData.c = n2;
        lineCommentLineData.b = bl2;
        list2.add(lineCommentLineData);
    }

    @Override
    @NotNull
    public CommentLineData parseLine(@NotNull String line) {
        int n2;
        long l2 = i ^ 0x40E8D4EB9B8EL;
        if (line == null) {
            LineCommentLineDataBuilder.a(4);
        }
        LineCommentLineData lineCommentLineData = new LineCommentLineData(line);
        lineCommentLineData.commentOffset = LineCommentLineDataBuilder.nextNonWhitespace(line, 0);
        if (lineCommentLineData.commentOffset >= 0 && (n2 = lineCommentLineData.commentOffset + h.length()) < line.length()) {
            lineCommentLineData.textStartOffset = LineCommentLineDataBuilder.nextNonWhitespace(line, n2);
        }
        LineCommentLineData lineCommentLineData2 = lineCommentLineData;
        if (lineCommentLineData2 == null) {
            LineCommentLineDataBuilder.a(5);
        }
        return lineCommentLineData2;
    }

    public boolean isAfterNonEmptyLine(@NotNull ASTNode node) {
        ASTNode aSTNode;
        if (node == null) {
            LineCommentLineDataBuilder.a(6);
        }
        if (node.getElementType() == this.g && (aSTNode = node.getTreePrev()) != null) {
            return !(aSTNode.getPsi() instanceof PsiWhiteSpace) || !aSTNode.textContains('\n');
        }
        return false;
    }

    public static int countLineBreaks(@NotNull ASTNode node) {
        if (node == null) {
            LineCommentLineDataBuilder.a(7);
        }
        CharSequence charSequence = node.getChars();
        int n2 = 0;
        for (int i10 = 0; i10 < charSequence.length(); ++i10) {
            if (charSequence.charAt(i10) != '\n') continue;
            ++n2;
        }
        return n2;
    }

    public int calcBlockLineIndent(@NotNull ASTNode node) {
        ASTNode aSTNode;
        long l2 = i ^ 0x7FE11E6B5126L;
        if (node == null) {
            LineCommentLineDataBuilder.a(8);
        }
        int n2 = 0;
        for (aSTNode = node.getTreePrev(); aSTNode != null && !aSTNode.textContains('\n'); aSTNode = aSTNode.getTreePrev()) {
            n2 += aSTNode.getTextLength();
        }
        if (aSTNode != null) {
            int n3 = 0;
            CharSequence charSequence = aSTNode.getChars();
            int n4 = CharArrayUtil.shiftBackwardUntil((CharSequence)charSequence, (int)(aSTNode.getTextLength() - 1), (String)"\r\n");
            if (n4 >= 0) {
                n3 += aSTNode.getTextLength() - n4 - 1;
            }
            char[] cArray = CharArrayUtil.fromSequence((CharSequence)charSequence, (int)(aSTNode.getTextLength() - n3), (int)aSTNode.getTextLength());
            this.f = 0;
            boolean bl2 = cArray.length > 0 && cArray[0] == '\t';
            for (char c10 : cArray) {
                if (c10 == '\t' && bl2) {
                    n2 += this.b.TAB_SIZE;
                    ++this.f;
                    continue;
                }
                bl2 = false;
                ++n2;
            }
        }
        return n2;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = i ^ 0x26719C67D139L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 5: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/webcore/formatter/comments/LineCommentLineDataBuilder";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/webcore/formatter/comments/LineCommentLineDataBuilder";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "parseLine";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isMergedWithPrevious";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addLineDataFromComment";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parseLine";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isAfterNonEmptyLine";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "countLineBreaks";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "calcBlockLineIndent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class LineCommentLineData
    extends CommentLineData {
        private int c;
        private boolean b;
        private static final long e = lb.a(6078886209214252670L, -2780067829301834500L, MethodHandles.lookup().lookupClass()).a(195153978752870L);

        LineCommentLineData(String line) {
            if (line == null) {
                LineCommentLineData.a(0);
            }
            super(line);
        }

        @Override
        public int getLineLength() {
            return this.c + super.getLineLength();
        }

        @Override
        protected int calcWrapPos(int rightMargin) {
            if (this.c < rightMargin) {
                return super.calcWrapPos(rightMargin - this.c);
            }
            return -1;
        }

        public String getIndentString() {
            if (!((LineCommentLineDataBuilder)LineCommentLineDataBuilder.this).b.USE_TAB_CHARACTER) {
                return StringUtil.repeatSymbol((char)' ', (int)this.c);
            }
            int n2 = ((LineCommentLineDataBuilder)LineCommentLineDataBuilder.this).b.SMART_TABS ? LineCommentLineDataBuilder.this.f : (((LineCommentLineDataBuilder)LineCommentLineDataBuilder.this).b.TAB_SIZE > 0 ? this.c / ((LineCommentLineDataBuilder)LineCommentLineDataBuilder.this).b.TAB_SIZE : 0);
            int n3 = this.c - n2 * ((LineCommentLineDataBuilder)LineCommentLineDataBuilder.this).b.TAB_SIZE;
            return StringUtil.repeatSymbol((char)'\t', (int)n2) + StringUtil.repeatSymbol((char)' ', (int)n3);
        }

        @Override
        @Nullable
        public Pair<String, String> splitLine(int rightMargin) {
            Pair<String, String> pair2 = super.splitLine(rightMargin);
            if (pair2 != null && !this.b && this.c > 0) {
                return Pair.create((Object)(this.getIndentString() + (String)pair2.first), (Object)pair2.second);
            }
            return pair2;
        }

        @Override
        @NotNull
        public String getLinePrefix() {
            long l2 = e ^ 0x47BE36D49487L;
            String string = (this.c > 0 ? this.getIndentString() : this.line.substring(0, this.commentOffset)) + LineCommentLineDataBuilder.h;
            if (string == null) {
                LineCommentLineData.a(1);
            }
            return string;
        }

        @Override
        protected int getTabSize() {
            return ((LineCommentLineDataBuilder)LineCommentLineDataBuilder.this).b.TAB_SIZE;
        }

        @Override
        @NotNull
        public String getLine() {
            String string = this.c > 0 && !this.b ? this.getIndentString() + this.line : this.line;
            if (string == null) {
                LineCommentLineData.a(2);
            }
            return string;
        }

        @Override
        public boolean canBeMergedWithPrevious() {
            return true;
        }

        private static /* synthetic */ void a(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            long l2 = e ^ 0x29F288C869DBL;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "line";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/webcore/formatter/comments/LineCommentLineDataBuilder$LineCommentLineData";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/webcore/formatter/comments/LineCommentLineDataBuilder$LineCommentLineData";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLinePrefix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLine";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

