/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.libraries.ui;

import b.a.lb;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.download.DownloadableFileSetDescription;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.SwingHelper;
import com.intellij.webcore.ModuleHelper;
import com.intellij.webcore.libraries.LangScriptingContextProvider;
import com.intellij.webcore.libraries.ScriptingLibraryManager;
import com.intellij.webcore.libraries.ScriptingLibraryMappings;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import com.intellij.webcore.libraries.ui.ModuleScopeSelectionDialog;
import com.intellij.webcore.libraries.ui.PartlySelectedCheckBoxEditor;
import com.intellij.webcore.libraries.ui.PartlySelectedCheckBoxRenderer;
import com.intellij.webcore.libraries.ui.PerFileMappingsDialogWrapper;
import com.intellij.webcore.libraries.ui.ScriptingContextsConfigurable;
import com.intellij.webcore.libraries.ui.ScriptingLibraryTableModel;
import com.intellij.webcore.libraries.ui.download.DownloadWebLibraryDialog;
import com.intellij.webcore.libraries.ui.download.DownloadableFileSetDescriptionWithUrl;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScriptingLibrariesPanelStub {
    private JPanel e;
    protected JButton myManageScopesButton;
    protected Project myProject;
    protected ScriptingLibraryTableModel myLibTableModel;
    protected JBTable myLibraryTable;
    private JPanel c;
    protected JButton myDownloadButton;
    private JButton d;
    protected LangScriptingContextProvider myProvider;
    protected final ScriptingLibraryManager myLibraryManager;
    private final ScriptingLibraryMappings a;
    private boolean b;
    private static final long o = lb.a(-7950000370694178057L, 2956341839335765128L, MethodHandles.lookup().lookupClass()).a(81389523814658L);

    public ScriptingLibrariesPanelStub(Project project2, LangScriptingContextProvider provider, final ScriptingLibraryManager libraryManager) {
        long l2 = o ^ 0x7E98CFB9486BL;
        this.b = false;
        this.myProject = project2;
        this.myProvider = provider;
        this.d();
        this.a = provider.getLibraryMappings(project2);
        this.myLibraryManager = libraryManager;
        this.myProvider = provider;
        this.myLibTableModel = new ScriptingLibraryTableModel(libraryManager, this.a);
        this.myLibraryTable.setModel((TableModel)this.myLibTableModel);
        this.myLibraryTable.setRowHeight((int)((double)this.myLibraryTable.getRowHeight() * 1.2));
        JTableHeader jTableHeader = this.myLibraryTable.getTableHeader();
        jTableHeader.setReorderingAllowed(false);
        TableColumn tableColumn = this.myLibraryTable.getColumnModel().getColumn(0);
        ScriptingLibrariesPanelStub.a(tableColumn, JBUI.scale((int)60));
        tableColumn.setCellRenderer(new PartlySelectedCheckBoxRenderer());
        tableColumn.setCellEditor(new PartlySelectedCheckBoxEditor(this));
        this.myLibraryTable.getColumnModel().getColumn(1).setCellRenderer(new LibraryNameCellRenderer());
        SwingHelper.setNoBorderCellRendererFor((TableColumn)this.myLibraryTable.getColumnModel().getColumn(1));
        int n2 = this.myLibraryTable.getFontMetrics(this.myLibraryTable.getFont()).stringWidth("Predefined") + JBUI.scale((int)10);
        ScriptingLibrariesPanelStub.a(this.myLibraryTable.getColumnModel().getColumn(2), n2);
        this.myLibraryTable.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e10) {
                if (e10.getKeyChar() == ' ') {
                    int[] nArray = ScriptingLibrariesPanelStub.this.myLibraryTable.getSelectedRows();
                    boolean bl2 = true;
                    for (int n2 : nArray) {
                        if (ScriptingLibraryTableModel.EnabledState.ON == ScriptingLibrariesPanelStub.this.myLibTableModel.getValueAt(n2, 0)) continue;
                        bl2 = false;
                    }
                    for (int n2 : nArray) {
                        if (!bl2 && ScriptingLibraryTableModel.EnabledState.ON != ScriptingLibrariesPanelStub.this.myLibTableModel.getValueAt(n2, 0)) {
                            ScriptingLibrariesPanelStub.this.myLibTableModel.setValueAt(Boolean.TRUE, n2, 0);
                            continue;
                        }
                        if (!bl2) continue;
                        ScriptingLibrariesPanelStub.this.myLibTableModel.setValueAt(Boolean.FALSE, n2, 0);
                    }
                }
            }
        });
        this.d.setToolTipText("Configure JavaScript library (Project Structure)");
        this.d.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e10) {
                String string;
                ScriptingLibraryModel scriptingLibraryModel;
                LibraryTable.Listener listener = new LibraryTable.Listener(){
                    private static final long a = lb.a(1789064670750842870L, 3544257755013365577L, MethodHandles.lookup().lookupClass()).a(106909820349117L);

                    public void afterLibraryAdded(@NotNull Library newLibrary) {
                        if (newLibrary == null) {
                            1.a(0);
                        }
                        ScriptingLibrariesPanelStub.this.myLibraryManager.reset();
                    }

                    public void afterLibraryRenamed(@NotNull Library library) {
                        if (library == null) {
                            1.a(1);
                        }
                        ScriptingLibrariesPanelStub.this.myLibraryManager.reset();
                    }

                    public void afterLibraryRemoved(@NotNull Library library) {
                        if (library == null) {
                            1.a(2);
                        }
                        ScriptingLibrariesPanelStub.this.myLibraryManager.reset();
                    }

                    private static /* synthetic */ void a(int n2) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        long l2 = a ^ 0x177DDF4E0779L;
                        Object[] objectArray3 = new Object[3];
                        switch (n2) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "newLibrary";
                                break;
                            }
                            case 1: 
                            case 2: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "library";
                                break;
                            }
                        }
                        objectArray2[1] = "com/intellij/webcore/libraries/ui/ScriptingLibrariesPanelStub$2$1";
                        switch (n2) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "afterLibraryAdded";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "afterLibraryRenamed";
                                break;
                            }
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[2] = "afterLibraryRemoved";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
                ScriptingLibrariesPanelStub.this.myProvider.getLibraryMappings(ScriptingLibrariesPanelStub.this.myProject).registerLibraryTableListener(listener, (Disposable)ScriptingLibrariesPanelStub.this.a);
                for (ScriptingLibraryModel scriptingLibraryModel2 : ScriptingLibrariesPanelStub.this.myLibraryManager.getAllLibraries()) {
                    Library library = scriptingLibraryModel2.getOriginalLibrary();
                    if (library == null) continue;
                    library.getRootProvider().addRootSetChangedListener(rootProvider -> {
                        scriptingLibraryModel2.setSourceFiles(library.getFiles(OrderRootType.SOURCES));
                        scriptingLibraryModel2.setCompactFiles(library.getFiles(OrderRootType.CLASSES));
                        scriptingLibraryModel2.setDocUrls(library.getUrls(OrderRootType.DOCUMENTATION));
                    }, (Disposable)ScriptingLibrariesPanelStub.this.a);
                }
                Library library = null;
                if (ScriptingLibrariesPanelStub.this.myLibraryTable.getSelectedRowCount() == 1 && (scriptingLibraryModel = libraryManager.getLibraryByName(string = ScriptingLibrariesPanelStub.this.myLibTableModel.getLibNameAt(ScriptingLibrariesPanelStub.this.myLibraryTable.getSelectedRow()))) != null && !scriptingLibraryModel.isPredefined()) {
                    library = scriptingLibraryModel.getOriginalLibrary();
                }
                if (library != null) {
                    ProjectSettingsService.getInstance((Project)ScriptingLibrariesPanelStub.this.myProject).openLibrary(library);
                } else {
                    ProjectSettingsService.getInstance((Project)ScriptingLibrariesPanelStub.this.myProject).openGlobalLibraries();
                }
                ScriptingLibrariesPanelStub.this.myLibTableModel.fireLibTableChanged(true);
            }
        });
        this.myDownloadButton.setToolTipText("Download from content delivery network (CDN) and install");
        this.myDownloadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e10) {
                ScriptingLibrariesPanelStub.this.a(ScriptingLibrariesPanelStub.this.getPanel());
            }
        });
        this.myManageScopesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e10) {
                ScriptingLibrariesPanelStub.this.e();
            }
        });
        this.c.setBorder(IdeBorderFactory.createTitledBorder((String)"Libraries"));
    }

    private static void a(@NotNull TableColumn tableColumn, int n2) {
        if (tableColumn == null) {
            ScriptingLibrariesPanelStub.a(0);
        }
        tableColumn.setPreferredWidth(n2);
        tableColumn.setMaxWidth(n2);
    }

    public JComponent getPanel() {
        return this.e;
    }

    public boolean isModified() {
        return this.myLibTableModel.isChanged() || this.b;
    }

    public void resetTable() {
        this.myLibTableModel.resetTable();
        this.b = false;
    }

    public void apply() {
        this.a.updateAssociations(() -> this.b());
    }

    private void b() {
        this.myLibTableModel.applyChanges();
        Map map2 = this.a.getMappings();
        for (ScriptingLibraryModel scriptingLibraryModel : map2.values()) {
            if (!(scriptingLibraryModel instanceof ScriptingLibraryMappings.CompoundLibrary)) continue;
            ((ScriptingLibraryMappings.CompoundLibrary)scriptingLibraryModel).applyChanges();
        }
    }

    protected void selectLibrary(String libName) {
        int n2 = this.myLibTableModel.getLibraryIndex(libName);
        if (n2 >= 0) {
            this.myLibraryTable.getSelectionModel().setSelectionInterval(n2, n2);
        }
    }

    protected void afterDownload(DownloadableFileSetDescription description) {
        this.myLibTableModel.fireLibTableChanged(true);
        String string = LangScriptingContextProvider.getIdeLibraryName(description);
        assert (string != null);
        this.selectLibrary(string);
        if (ModuleHelper.getModules((Project)this.myProject).length > 1) {
            this.configureModules();
        }
    }

    private void a(@NotNull Component component) {
        DownloadWebLibraryDialog downloadWebLibraryDialog;
        if (component == null) {
            ScriptingLibrariesPanelStub.a(1);
        }
        if ((downloadWebLibraryDialog = new DownloadWebLibraryDialog(this.myProject, this.myProvider)).showAndGet()) {
            DownloadableFileSetDescriptionWithUrl downloadableFileSetDescriptionWithUrl = downloadWebLibraryDialog.getSelection();
            if (downloadableFileSetDescriptionWithUrl == null) {
                return;
            }
            if (this.isModified()) {
                WriteAction.run(() -> {
                    this.apply();
                    this.myLibraryManager.commitChanges();
                });
            }
            downloadableFileSetDescriptionWithUrl.downloadLibrary(this.myProject, this.myProvider, component, () -> this.afterDownload(downloadableFileSetDescriptionWithUrl));
        }
    }

    private void e() {
        long l2 = o ^ 0x169BA4DAA421L;
        this.myLibTableModel.applyMappings();
        ScriptingContextsConfigurable scriptingContextsConfigurable = new ScriptingContextsConfigurable(this.myProject, this.a);
        PerFileMappingsDialogWrapper perFileMappingsDialogWrapper = new PerFileMappingsDialogWrapper(this.getPanel(), scriptingContextsConfigurable);
        perFileMappingsDialogWrapper.setTitle(this.myProvider.getLanguage().getDisplayName() + " Libraries Usage Scopes");
        if (perFileMappingsDialogWrapper.showAndGet() && scriptingContextsConfigurable.isModified()) {
            this.b = true;
            this.myLibTableModel.fireLibTableChanged(false);
        }
    }

    int configureModules() {
        String string;
        ScriptingLibraryModel scriptingLibraryModel;
        if (ModuleHelper.getModules((Project)this.myProject).length == 1) {
            return -1;
        }
        int n2 = this.myLibraryTable.getSelectedRow();
        if (n2 >= 0 && (scriptingLibraryModel = this.myLibraryManager.getLibraryByName(string = this.myLibTableModel.getLibNameAt(n2))) != null) {
            if (scriptingLibraryModel.isPredefined()) {
                return -1;
            }
            ModuleScopeSelectionDialog moduleScopeSelectionDialog = new ModuleScopeSelectionDialog(this.myProject, scriptingLibraryModel.getAssociatedModules(), null, scriptingLibraryModel.getName());
            if (moduleScopeSelectionDialog.showAndGet()) {
                Set<Module> set = moduleScopeSelectionDialog.getSelectedModules();
                if (!scriptingLibraryModel.getAssociatedModules().equals(set)) {
                    scriptingLibraryModel.setAssociatedModules(set);
                    this.a.updateMappings();
                    this.b = true;
                }
                return set.size();
            }
            return scriptingLibraryModel.getAssociatedModules().size();
        }
        return -1;
    }

    private static boolean a(@Nullable ScriptingLibraryModel scriptingLibraryModel) {
        if (scriptingLibraryModel == null) {
            return false;
        }
        return scriptingLibraryModel.getSourceFilePointers().stream().allMatch(virtualFilePointer -> virtualFilePointer.getFile() != null) && scriptingLibraryModel.getCompactFilePointers().stream().allMatch(virtualFilePointer -> virtualFilePointer.getFile() != null);
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = o ^ 0x7DA3B1A6CF56L;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationAreaComponent";
                break;
            }
        }
        objectArray2[1] = "com/intellij/webcore/libraries/ui/ScriptingLibrariesPanelStub";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setColumnWidth";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "showDownloadDialog";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void d() {
        JButton jButton;
        JButton jButton2;
        JButton jButton3;
        JBTable jBTable;
        JPanel jPanel;
        JPanel jPanel2;
        long l2 = o ^ 0x7A5B95CA25A6L;
        this.e = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        this.c = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)"Libraries", (int)0, (int)0, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(0, 0, 4, 1, 0, 3, 7, 7, null, null, null));
        this.myLibraryTable = jBTable = new JBTable();
        jBTable.setStriped(true);
        jBScrollPane.setViewportView((Component)jBTable);
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myManageScopesButton = jButton3 = new JButton();
        jButton3.setText("Manage Scopes...");
        jButton3.setMnemonic('S');
        jButton3.setDisplayedMnemonicIndex(7);
        jPanel.add((Component)jButton3, new GridConstraints(2, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myDownloadButton = jButton2 = new JButton();
        jButton2.setText("Download...");
        jButton2.setMnemonic('D');
        jButton2.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jButton2, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.d = jButton = new JButton();
        jButton.setText("Configure...");
        jButton.setMnemonic('C');
        jButton.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.e;
    }

    private class LibraryNameCellRenderer
    extends DefaultTableCellRenderer {
        private LibraryNameCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            ScriptingLibraryModel scriptingLibraryModel;
            boolean bl2;
            this.setForeground(null);
            Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (row >= 0 && row < ScriptingLibrariesPanelStub.this.myLibTableModel.getRowCount() && !(bl2 = ScriptingLibrariesPanelStub.a(scriptingLibraryModel = ScriptingLibrariesPanelStub.this.myLibTableModel.getLibraryAt(row))) && !isSelected) {
                this.setForeground((Color)JBColor.red);
            }
            return component;
        }
    }
}

