/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository.actions;

import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.settingsRepository.IcsBundleKt;
import org.jetbrains.settingsRepository.IcsManagerKt;
import org.jetbrains.settingsRepository.SyncManager;
import org.jetbrains.settingsRepository.SyncType;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\n"}, d2={"NOTIFICATION_GROUP", "Lcom/intellij/notification/NotificationGroup;", "getNOTIFICATION_GROUP", "()Lcom/intellij/notification/NotificationGroup;", "syncAndNotify", "", "syncType", "Lorg/jetbrains/settingsRepository/SyncType;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.settingsRepository"})
public final class SyncActionKt {
    @NotNull
    private static final NotificationGroup NOTIFICATION_GROUP;

    @NotNull
    public static final NotificationGroup getNOTIFICATION_GROUP() {
        return NOTIFICATION_GROUP;
    }

    private static final void syncAndNotify(SyncType syncType, Project project) {
        try {
            String message = SyncManager.sync$default(IcsManagerKt.getIcsManager().getSyncManager$intellij_settingsRepository(), syncType, project, null, false, 12, null) ? IcsBundleKt.icsMessage("sync.done.message", new Object[0]) : IcsBundleKt.icsMessage("sync.up.to.date.message", new Object[0]);
            NOTIFICATION_GROUP.createNotification(message, NotificationType.INFORMATION).notify(project);
        }
        catch (Exception e) {
            IcsManagerKt.getLOG().warn((Throwable)e);
            String string = IcsBundleKt.icsMessage("sync.rejected.title", new Object[0]);
            String string2 = e.getMessage();
            if (string2 == null) {
                string2 = "Internal error";
            }
            NOTIFICATION_GROUP.createNotification(string, string2, NotificationType.ERROR, null).notify(project);
        }
    }

    static {
        NotificationGroup notificationGroup = NotificationGroup.balloonGroup((String)"Settings Repository");
        Intrinsics.checkExpressionValueIsNotNull((Object)notificationGroup, (String)"NotificationGroup.balloonGroup(PLUGIN_NAME)");
        NOTIFICATION_GROUP = notificationGroup;
    }

    public static final /* synthetic */ void access$syncAndNotify(@NotNull SyncType syncType, @Nullable Project project) {
        SyncActionKt.syncAndNotify(syncType, project);
    }
}

