/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.view.tool.action;

import com.intellij.j2ee.openapi.ex.DeploymentManagerEx;
import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.deployment.DeploymentProvider;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.serverInstances.J2EEServerInstance;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectModelBuildableElement;
import com.intellij.openapi.util.Pair;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.task.ProjectTaskManager;
import com.intellij.task.ProjectTaskNotification;
import com.intellij.task.ProjectTaskResult;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DeploymentWorker {
    private static final Logger LOG = Logger.getInstance(DeploymentWorker.class);
    private final List<Pair<J2EEServerInstance, DeploymentModel>> myDeploymentItems = new ArrayList<Pair<J2EEServerInstance, DeploymentModel>>();
    private final Project myProject;

    public DeploymentWorker(Project project) {
        this.myProject = project;
    }

    public void addDeploymentItem(@NotNull J2EEServerInstance server, @NotNull DeploymentModel artifact) {
        if (server == null) {
            DeploymentWorker.$$$reportNull$$$0(0);
        }
        if (artifact == null) {
            DeploymentWorker.$$$reportNull$$$0(1);
        }
        this.myDeploymentItems.add((Pair<J2EEServerInstance, DeploymentModel>)Pair.create((Object)server, (Object)artifact));
    }

    public void compileAndDeploy() {
        if (this.myDeploymentItems.isEmpty()) {
            return;
        }
        LinkedHashSet<Artifact> artifacts = new LinkedHashSet<Artifact>();
        for (Pair<J2EEServerInstance, DeploymentModel> deploymentItem : this.myDeploymentItems) {
            Artifact artifact = ((DeploymentModel)deploymentItem.getSecond()).getArtifact();
            if (artifact == null) continue;
            artifacts.add(artifact);
        }
        if (artifacts.isEmpty()) {
            this.deploy();
        } else {
            ProjectTaskManager.getInstance((Project)this.myProject).build((ProjectModelBuildableElement[])artifacts.toArray(new Artifact[0]), new ProjectTaskNotification(){

                public void finished(@NotNull ProjectTaskResult executionResult) {
                    if (executionResult == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (!executionResult.isAborted() && executionResult.getErrors() == 0) {
                        DeploymentWorker.this.deploy();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executionResult", "com/intellij/javaee/view/tool/action/DeploymentWorker$1", "finished"));
                }
            });
        }
    }

    private void deploy() {
        for (Pair<J2EEServerInstance, DeploymentModel> deploymentItem : this.myDeploymentItems) {
            DeploymentProvider provider = DeploymentManagerEx.getProvider((CommonModel)((J2EEServerInstance)deploymentItem.getFirst()).getCommonModel());
            if (provider != null) {
                provider.doDeploy(this.myProject, (J2EEServerInstance)deploymentItem.getFirst(), (DeploymentModel)deploymentItem.getSecond());
                continue;
            }
            LOG.error("DeploymentProvider is expected to exist");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "server";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "artifact";
                break;
            }
        }
        objectArray[1] = "com/intellij/javaee/view/tool/action/DeploymentWorker";
        objectArray[2] = "addDeploymentItem";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

