/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.redshift.model;

import com.intellij.database.dialects.redshift.model.RsExternalSchema;
import com.intellij.database.dialects.redshift.model.RsExternalTableColumn;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIdentifiedElement;
import com.intellij.database.model.basic.BasicMajorObject;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.NamingIdentifyingFamily;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.database.model.properties.RsExternalTableStorageType;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface RsExternalTable
extends BasicTable,
BasicMajorObject,
BasicIdentifiedElement,
BasicNamedElement {
    @Override
    @NotNull
    default public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.FOREIGN_TABLE;
        if (objectKind == null) {
            RsExternalTable.$$$reportNull$$$0(0);
        }
        return objectKind;
    }

    @Override
    @Nullable
    public RsExternalSchema getSchema();

    @Override
    @Nullable
    default public RsExternalSchema getParent() {
        return this.getSchema();
    }

    default public @Nullable NamingIdentifyingFamily<@NotNull ? extends RsExternalTable> getParentFamily() {
        return null;
    }

    @NotNull
    public @NotNull PositioningNamingFamily<@NotNull ? extends RsExternalTableColumn> getColumns();

    @Override
    @NotNull
    default public List<ObjectKind> getFamilyKinds() {
        List<ObjectKind> list = Collections.singletonList(ObjectKind.COLUMN);
        if (list == null) {
            RsExternalTable.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull List<@NotNull ? extends Family<@NotNull ? extends BasicElement>> getFamilies() {
        List<PositioningNamingFamily<? extends RsExternalTableColumn>> list = Collections.singletonList(this.getColumns());
        if (list == null) {
            RsExternalTable.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Override
    @Nullable
    default public String getComment() {
        return null;
    }

    @Nullable
    default public String getSerializationLib() {
        return null;
    }

    @Nullable
    default public String getInputFormat() {
        return null;
    }

    @Nullable
    default public String getOutputFormat() {
        return null;
    }

    @Nullable
    default public String getLocation() {
        return null;
    }

    @NotNull
    default public RsExternalTableStorageType getStorageType() {
        RsExternalTableStorageType rsExternalTableStorageType = RsExternalTableStorageType.UNKNOWN;
        if (rsExternalTableStorageType == null) {
            RsExternalTable.$$$reportNull$$$0(3);
        }
        return rsExternalTableStorageType;
    }

    @NotNull
    default public List<String> getSerdeProperties() {
        List<String> list = Collections.emptyList();
        if (list == null) {
            RsExternalTable.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    default public List<String> getProps() {
        List<String> list = Collections.emptyList();
        if (list == null) {
            RsExternalTable.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Override
    default public void exportProperties(@NotNull NameValueConsumer<String> consumer2) {
        List<String> props;
        List<String> serdeProperties;
        RsExternalTableStorageType storageType;
        String location;
        String outputFormat;
        String inputFormat;
        String serializationLib;
        String comment;
        boolean nameQuoted;
        boolean nameScripted;
        boolean nameSurrogate;
        String name;
        long objectId;
        if (consumer2 == null) {
            RsExternalTable.$$$reportNull$$$0(6);
        }
        if ((objectId = this.getObjectId()) != Long.MIN_VALUE) {
            consumer2.accept("ObjectId", PropertyConverter.export(objectId));
        }
        if ((name = this.getName()) != null && name != ModelConsts.NO_NAME) {
            consumer2.accept("Name", PropertyConverter.export(name));
        }
        if (nameSurrogate = this.isNameSurrogate()) {
            consumer2.accept("NameSurrogate", PropertyConverter.export(nameSurrogate));
        }
        if (nameScripted = this.isNameScripted()) {
            consumer2.accept("NameScripted", PropertyConverter.export(nameScripted));
        }
        if (nameQuoted = this.isNameQuoted()) {
            consumer2.accept("NameQuoted", PropertyConverter.export(nameQuoted));
        }
        if ((comment = this.getComment()) != null) {
            consumer2.accept("Comment", PropertyConverter.export(comment));
        }
        if ((serializationLib = this.getSerializationLib()) != null) {
            consumer2.accept("SerializationLib", PropertyConverter.export(serializationLib));
        }
        if ((inputFormat = this.getInputFormat()) != null) {
            consumer2.accept("InputFormat", PropertyConverter.export(inputFormat));
        }
        if ((outputFormat = this.getOutputFormat()) != null) {
            consumer2.accept("OutputFormat", PropertyConverter.export(outputFormat));
        }
        if ((location = this.getLocation()) != null) {
            consumer2.accept("Location", PropertyConverter.export(location));
        }
        if ((storageType = this.getStorageType()) != null && storageType != RsExternalTableStorageType.UNKNOWN) {
            consumer2.accept("StorageType", PropertyConverter.export(storageType));
        }
        if (!(serdeProperties = this.getSerdeProperties()).isEmpty()) {
            consumer2.accept("SerdeProperties", PropertyConverter.exportListOfString(serdeProperties));
        }
        if (!(props = this.getProps()).isEmpty()) {
            consumer2.accept("Props", PropertyConverter.exportListOfString(props));
        }
    }

    @Override
    @NotNull
    default public List<String> getPropertyNames() {
        List<String> list = Arrays.asList("ObjectId", "Name", "NameSurrogate", "NameScripted", "NameQuoted", "Comment", "SerializationLib", "InputFormat", "OutputFormat", "Location", "StorageType", "SerdeProperties", "Props");
        if (list == null) {
            RsExternalTable.$$$reportNull$$$0(7);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/redshift/model/RsExternalTable";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyKinds";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilies";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStorageType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSerdeProperties";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProps";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/redshift/model/RsExternalTable";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyNames";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "exportProperties";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

