/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTypedObject;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlCreateIndexStatement;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlReferenceList;
import com.intellij.sql.psi.SqlTableColumnsList;
import com.intellij.sql.psi.SqlTargetContextProvider;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlKIFKImpl;
import com.intellij.sql.psi.impl.SqlOnTargetClauseImpl;
import com.intellij.sql.psi.stubs.SqlTableKeyStub;
import com.intellij.util.ObjectUtils;
import icons.DatabaseIcons;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlCreateIndexStatementImpl
extends SqlKIFKImpl<SqlTableKeyStub<?>>
implements SqlCreateIndexStatement,
SqlTargetContextProvider {
    public SqlCreateIndexStatementImpl(@NotNull ASTNode node) {
        if (node == null) {
            SqlCreateIndexStatementImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    public SqlCreateIndexStatementImpl(SqlTableKeyStub stub) {
        super(stub, SqlCompositeElementTypes.SQL_CREATE_INDEX_STATEMENT);
    }

    @Override
    protected SqlReferenceElementType getExpectedNameReferenceElementType() {
        return SqlCompositeElementTypes.SQL_INDEX_REFERENCE;
    }

    @Override
    public String getTableName() {
        SqlReferenceExpression ref = this.getTargetReference();
        return ref == null ? null : ref.getText();
    }

    @Override
    public void accept(SqlVisitor visitor2) {
        visitor2.visitSqlCreateIndexStatement((SqlCreateIndexStatement)this);
    }

    @Nullable
    public SqlReferenceExpression getTargetReference() {
        SqlTableKeyStub stub = (SqlTableKeyStub)this.getStub();
        if (stub != null) {
            SqlTableColumnsList columnList = stub.getKeyColumnList();
            return columnList == null ? null : columnList.getTableReference();
        }
        SqlOnTargetClauseImpl clause = this.findTargetClause();
        return clause == null ? null : (SqlReferenceExpression)ObjectUtils.tryCast((Object)clause.getTargetExpression(), SqlReferenceExpression.class);
    }

    @Nullable
    private SqlTableColumnsList getTableColumnsList() {
        SqlTableKeyStub stub = (SqlTableKeyStub)this.getStub();
        if (stub != null) {
            return stub.getKeyColumnList();
        }
        return (SqlTableColumnsList)PsiTreeUtil.getChildOfType((PsiElement)this.findTargetClause(), SqlTableColumnsList.class);
    }

    private SqlOnTargetClauseImpl findTargetClause() {
        return (SqlOnTargetClauseImpl)this.findChildByType((IElementType)SqlCompositeElementTypes.SQL_ON_TARGET_CLAUSE);
    }

    @NotNull
    public DasIndex.Sorting getColumnSorting(@NotNull DasTypedObject column2) {
        if (column2 == null) {
            SqlCreateIndexStatementImpl.$$$reportNull$$$0(1);
        }
        DasIndex.Sorting sorting = DasIndex.Sorting.NONE;
        if (sorting == null) {
            SqlCreateIndexStatementImpl.$$$reportNull$$$0(2);
        }
        return sorting;
    }

    @Override
    @Nullable
    protected SqlReferenceList getColumnsList() {
        SqlTableColumnsList tableColumnsList = this.getTableColumnsList();
        return tableColumnsList == null ? null : tableColumnsList.getColumnsReferenceList();
    }

    public List<SqlReferenceExpression> getColumnReferences() {
        return SqlImplUtil.getReferenceList(this.getTableColumnsList());
    }

    @Override
    @Nullable
    public DasTable getTable() {
        SqlReferenceExpression ref = this.getTargetReference();
        if (ref == null) {
            return null;
        }
        for (ResolveResult result2 : ref.multiResolve(false)) {
            if (!(result2.getElement() instanceof DasTable)) continue;
            return (DasTable)result2.getElement();
        }
        return null;
    }

    public boolean isUnique() {
        SqlTableKeyStub stub = (SqlTableKeyStub)this.getGreenStub();
        if (stub != null) {
            return stub.isUnique();
        }
        return this.findChildByType((IElementType)SqlCommonKeywords.SQL_UNIQUE) != null;
    }

    public boolean isFunctionBased() {
        return false;
    }

    @Override
    public Icon getIcon() {
        return DatabaseIcons.Index;
    }

    @Override
    public boolean processImplicitContextDeclarations(PsiScopeProcessor processor, ResolveState state, PsiElement lastParent, PsiElement place) {
        SqlReferenceExpression reference = this.getTargetReference();
        if (reference != null && !SqlImplUtil.processQualifier(reference, processor, state, place)) {
            return false;
        }
        return super.processImplicitContextDeclarations(processor, state, lastParent, place);
    }

    @Nullable
    public SqlReferenceExpression getTargetContextExpression() {
        return this.getTargetReference();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/impl/SqlCreateIndexStatementImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/impl/SqlCreateIndexStatementImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnSorting";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getColumnSorting";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

