/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.explorer;

import com.intellij.lang.ant.AntBundle;
import com.intellij.lang.ant.config.AntBuildFile;
import com.intellij.lang.ant.config.AntConfigurationBase;
import com.intellij.lang.ant.config.impl.ExecuteCompositeTargetEvent;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.ui.ListUtil;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBList;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;

public class SaveMetaTargetDialog
extends DialogWrapper {
    private JList myTargetList;
    private JTextField myTfName;
    private final ExecuteCompositeTargetEvent myInitialEvent;
    private final AntConfigurationBase myAntConfiguration;
    private final AntBuildFile myBuildFile;

    public SaveMetaTargetDialog(Component parent, ExecuteCompositeTargetEvent event, AntConfigurationBase antConfiguration, AntBuildFile buildFile) {
        super(parent, true);
        this.myInitialEvent = event;
        this.myAntConfiguration = antConfiguration;
        this.myBuildFile = buildFile;
        this.setModal(true);
        this.init();
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.ant.explorer.SaveMetaTargetDialog";
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction()};
        if (actionArray == null) {
            SaveMetaTargetDialog.$$$reportNull$$$0(0);
        }
        return actionArray;
    }

    protected void doOKAction() {
        ExecuteCompositeTargetEvent eventObject = this.createEventObject();
        if (this.myAntConfiguration.getTargetForEvent(eventObject) == null) {
            this.myAntConfiguration.setTargetForEvent(this.myBuildFile, eventObject.getMetaTargetName(), eventObject);
            super.doOKAction();
        } else {
            Messages.showInfoMessage((Component)this.getContentPane(), (String)AntBundle.message("save.meta.data.such.sequence.of.targets.already.exists.error.message", new Object[0]), (String)this.getTitle());
        }
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTfName;
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        JLabel nameLabel = new JLabel(AntBundle.message("save.meta.data.name.label", new Object[0]));
        panel.add((Component)nameLabel, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 18, 0, (Insets)JBUI.emptyInsets(), 0, 0));
        this.myTfName = new JTextField(this.myInitialEvent.getPresentableName());
        nameLabel.setLabelFor(this.myTfName);
        this.myTfName.selectAll();
        panel.add((Component)this.myTfName, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.insetsTop((int)4), 0, 0));
        DefaultListModel<String> dataModel = new DefaultListModel<String>();
        this.myTargetList = new JBList(dataModel);
        List<String> targetNames = this.myInitialEvent.getTargetNames();
        for (String name : targetNames) {
            dataModel.addElement(name);
        }
        panel.add((Component)new JLabel(AntBundle.message("save.meta.data.targets.label", new Object[0])), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 18, 0, (Insets)JBUI.insetsTop((int)6), 0, 0));
        panel.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myTargetList), new GridBagConstraints(0, -1, 1, 2, 1.0, 1.0, 18, 1, (Insets)JBUI.insetsTop((int)4), 0, 0));
        final JButton upButton = new JButton(AntBundle.message("button.move.up", new Object[0]));
        panel.add((Component)upButton, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 18, 2, (Insets)JBUI.insets((int)6, (int)6, (int)0, (int)0), 0, 0));
        final JButton downButton = new JButton(AntBundle.message("button.move.down", new Object[0]));
        panel.add((Component)downButton, new GridBagConstraints(1, 4, 1, 0, 0.0, 1.0, 18, 2, (Insets)JBUI.insetsLeft((int)6), 0, 0));
        class UpdateAction
        implements ActionListener {
            final /* synthetic */ JButton val$upButton;
            final /* synthetic */ JButton val$downButton;

            UpdateAction() {
                this.val$upButton = jButton;
                this.val$downButton = jButton2;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.val$upButton.setEnabled(ListUtil.canMoveSelectedItemsUp((JList)SaveMetaTargetDialog.this.myTargetList));
                this.val$downButton.setEnabled(ListUtil.canMoveSelectedItemsDown((JList)SaveMetaTargetDialog.this.myTargetList));
            }
        }
        upButton.addActionListener(new UpdateAction(){
            {
                super(SaveMetaTargetDialog.this, jButton2, jButton);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ListUtil.moveSelectedItemsUp((JList)SaveMetaTargetDialog.this.myTargetList);
                super.actionPerformed(e);
            }
        });
        downButton.addActionListener(new UpdateAction(){
            {
                super(SaveMetaTargetDialog.this, jButton2, jButton);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ListUtil.moveSelectedItemsDown((JList)SaveMetaTargetDialog.this.myTargetList);
                super.actionPerformed(e);
            }
        });
        this.myTargetList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                upButton.setEnabled(ListUtil.canMoveSelectedItemsUp((JList)SaveMetaTargetDialog.this.myTargetList));
                downButton.setEnabled(ListUtil.canMoveSelectedItemsDown((JList)SaveMetaTargetDialog.this.myTargetList));
            }
        });
        this.myTargetList.setSelectedIndex(0);
        return panel;
    }

    private ExecuteCompositeTargetEvent createEventObject() {
        ListModel model = this.myTargetList.getModel();
        int size = model.getSize();
        ArrayList<String> names = new ArrayList<String>();
        for (int idx = 0; idx < size; ++idx) {
            names.add((String)model.getElementAt(idx));
        }
        ExecuteCompositeTargetEvent event = new ExecuteCompositeTargetEvent(names);
        event.setPresentableName(this.myTfName.getText().trim());
        return event;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ant/config/explorer/SaveMetaTargetDialog", "createActions"));
    }
}

