// Copyright 2000-2018 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.boot.application;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;
import org.jetbrains.annotations.Nullable;

import java.util.List;

/**
 * @since 2018.1
 */
public interface SpringBootApplicationService {
  static SpringBootApplicationService getInstance() {
    return ServiceManager.getService(SpringBootApplicationService.class);
  }

  /**
   * @return {@code true} if class annotated with {@code @EnableAutoConfiguration} and can have main method, otherwise {@code false}.
   */
  boolean isSpringApplication(PsiClass psiClass);

  /**
   * @param module module to search classes
   * @return the list of all classes in production scope of the given module
   * for which {@link #isSpringApplication(PsiClass)} returns {@code true}.
   */
  List<PsiClass> getSpringApplications(Module module);

  /**
   * @param springBootClass Spring Boot application class
   * @return {@code true} if candidate class is found by {@link #findMainClassCandidate(PsiClass)} for the given Spring Boot application,
   * and it contains {@code public static void main} method, otherwise {@code false}.
   */
  boolean hasMainMethod(PsiClass springBootClass);

  /**
   * @param springBootClass Spring Boot application class
   * @return class itself or candidate class which may contain main method to start the given Spring Boot application
   */
  @Nullable
  PsiClass findMainClassCandidate(@Nullable PsiClass springBootClass);
}
