// Copyright 2000-2018 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.boot.application.config;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;

import java.util.List;

/**
 * Provides additional resolving for placeholder references.
 *
 * @see SpringBootPlaceholderReference
 * @since 2018.2
 */
public abstract class SpringBootPlaceholderReferenceResolver {

  public static final ExtensionPointName<SpringBootPlaceholderReferenceResolver> EP_NAME =
    ExtensionPointName.create("com.intellij.spring.boot.placeholderReferenceResolver");

  @NotNull
  public abstract List<PsiElement> resolve(SpringBootPlaceholderReference reference);

  @NotNull
  public abstract List<LookupElement> getVariants(SpringBootPlaceholderReference reference);
}
