// Copyright 2000-2017 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.boot.application.metadata;

import com.intellij.ide.presentation.Presentation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.FakePsiElement;

/**
 * Fake PSI reference to {@link SpringBootApplicationMetaConfigKey.ValueHint}.
 *
 * @since 2017.1
 */
@Presentation(typeName = "Value Hint")
public class ValueHintPsiElement extends FakePsiElement {

  private final PsiElement myParent;
  private final SpringBootApplicationMetaConfigKey.ValueHint myValueHint;

  public ValueHintPsiElement(PsiElement parent, SpringBootApplicationMetaConfigKey.ValueHint valueHint) {
    myParent = parent;
    myValueHint = valueHint;
  }

  @Override
  public PsiElement getParent() {
    return myParent;
  }

  @Override
  public String getName() {
    return myValueHint.getValue();
  }

  public SpringBootApplicationMetaConfigKey.ValueHint getValueHint() {
    return myValueHint;
  }
}
