// Copyright 2000-2018 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.boot.run.update;

import com.intellij.openapi.project.Project;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationDescriptor;
import org.jetbrains.annotations.NotNull;

import java.util.List;

public interface SpringBootApplicationUpdateContext {
  @NotNull
  Project getProject();

  /**
   * @return the list of running Spring Boot applications to update.
   */
  @NotNull
  List<SpringBootApplicationDescriptor> getDescriptors();

  boolean isOnFrameDeactivation();
}
