// Copyright 2000-2018 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.contexts.model.LocalAnnotationModel;
import com.intellij.spring.contexts.model.LocalXmlModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Set;

/**
 * NOTE: you should normally _not_ use Local*Model, but rather models provided via {@link SpringManager}.
 *
 * @since 2018.1
 */
public abstract class SpringLocalModelFactory {

  public static SpringLocalModelFactory getInstance() {
    return ServiceManager.getService(SpringLocalModelFactory.class);
  }

  @Nullable
  public abstract LocalAnnotationModel getOrCreateLocalAnnotationModel(@NotNull PsiClass psiClass,
                                                                       @NotNull Module module,
                                                                       @NotNull Set<String> activeProfiles);

  @Nullable
  public abstract LocalXmlModel getOrCreateLocalXmlModel(@NotNull XmlFile configFile,
                                                         @NotNull Module module,
                                                         @Nullable Set<String> activeProfiles);
}
