/*
 * Copyright 2000-2016 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.spring.contexts.model;

import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.model.SpringBeanPointer;

import java.util.Collection;

public abstract class CachedLocalModel extends AbstractProcessableModel implements CommonSpringModel {

  private volatile Collection<SpringBeanPointer> myLocalBeans; // beans defined in current file

  public Collection<SpringBeanPointer> getLocalBeans() {
    return myLocalBeans == null ? myLocalBeans = calculateLocalBeans() : myLocalBeans;
  }

  protected abstract Collection<SpringBeanPointer> calculateLocalBeans();
}
