/*
 * Copyright 2000-2015 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.spring.contexts.model;

import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.contexts.model.graph.LocalModelDependency;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringQualifier;
import com.intellij.spring.model.xml.context.SpringBeansPackagesScan;
import org.jetbrains.annotations.NotNull;

import java.util.Collections;
import java.util.List;
import java.util.Set;

public interface LocalModel<T extends PsiElement> extends CommonSpringModel {

  @NotNull
  T getConfig();

  /**
   * Returns all related local models: imported, component-scanned, @Enable*, ...
   *
   * @return Related models.
   * @since 14.1
   */
  Set<LocalModel> getRelatedLocalModels();

  /**
   * Returns all direct dependent local models (defined in local config {@link #getConfig()}).
   *
   * @return Dependent models.
   * @since 14.1
   */
  @NotNull
  Set<Pair<LocalModel, LocalModelDependency>> getDependentLocalModels();

  @NotNull
  default List<SpringBeansPackagesScan> getPackagesScans() {return Collections.emptyList();}

  @NotNull
  default List<SpringBeanPointer> findQualified(@NotNull SpringQualifier qualifier) {return Collections.emptyList();}

}
