// Copyright 2000-2018 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.contexts.model;

import com.intellij.openapi.util.Key;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.facet.beans.CustomSetting;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.util.xml.DomFileElement;
import com.intellij.xml.util.PsiElementPointer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Collection;
import java.util.List;

public abstract class LocalXmlModel extends AbstractSimpleLocalModel<XmlFile> {

  /**
   * @since 2017.2
   */
  public static final Key<CustomSetting.BOOLEAN> PROCESS_EXPLICITLY_ANNOTATED = Key.create("process_explicitly_annotated");

  @Nullable
  public abstract DomFileElement<Beans> getRoot();

  public abstract Collection<PsiElementPointer> getDuplicatedBeanNames(@NotNull String beanName);

  @NotNull
  public abstract List<SpringBeanPointer> getPlaceholderConfigurerBeans();

  @NotNull
  public abstract List<SpringBeanPointer> getAnnotationConfigAppContexts();

  public abstract Collection<XmlTag> getCustomBeans(String id);

  /**
   * Returns descendant beans having given context as "parent".
   *
   * @param context Bean to get descendants for.
   * @return Empty list by default.
   */
  @NotNull
  public abstract List<SpringBeanPointer> getDescendantBeans(final @NotNull SpringBeanPointer context) ;
}