// Copyright 2000-2018 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.el.contextProviders;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.psi.PsiLiteralExpression;
import org.jetbrains.annotations.NotNull;

import java.util.List;

/**
 * @since 2016.2
 */
public abstract class SpringElInjectionContext {

  private static final ExtensionPointName<SpringElInjectionContext> EP_NAME =
    new ExtensionPointName<>("com.intellij.spring.el.injection.context");

  public static List<SpringElInjectionContext> getProviders() {
    return EP_NAME.getExtensionList();
  }

  public abstract boolean isSpringElCompatibleHost(@NotNull PsiLiteralExpression host);
}
