/*
 * Copyright 2000-2018 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
 */
package com.intellij.spring.gutter.groups;

import com.intellij.codeHighlighting.Pass;
import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.MergeableLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.navigation.NavigationGutterIconRenderer;
import com.intellij.icons.AllIcons;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiElement;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.ConstantFunction;
import com.intellij.util.ui.JBUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import javax.swing.*;
import java.util.Collection;
import java.util.List;

import static com.intellij.spring.gutter.groups.SpringGutterIconBuilder.DEFAULT_GUTTER_ICON_ALIGNMENT;

public class SpringRelatedMergeableLineMarkerInfo extends RelatedItemLineMarkerInfo<PsiElement> {

  public SpringRelatedMergeableLineMarkerInfo(@NotNull PsiElement element,
                                              @NotNull Icon icon,
                                              @NotNull String tooltip,
                                              @Nullable GutterIconNavigationHandler<PsiElement> navHandler,
                                              @NotNull NotNullLazyValue<? extends Collection<? extends GotoRelatedItem>> targets) {
    super(element, element.getTextRange(), icon, Pass.LINE_MARKERS,
          new ConstantFunction<>(tooltip),
          navHandler, DEFAULT_GUTTER_ICON_ALIGNMENT, targets);
  }

  public SpringRelatedMergeableLineMarkerInfo(@NotNull PsiElement element,
                                              NavigationGutterIconRenderer renderer,
                                              @Nullable GutterIconNavigationHandler<PsiElement> navHandler,
                                              @NotNull NotNullLazyValue<? extends Collection<? extends GotoRelatedItem>> targets) {
    super(element, element.getTextRange(), renderer.getIcon(), Pass.LINE_MARKERS,
          renderer.getTooltipText() == null ? null : new ConstantFunction<>(renderer.getTooltipText()),
          navHandler, DEFAULT_GUTTER_ICON_ALIGNMENT,
          targets);
  }

  @NotNull
  @Override
  public GutterIconRenderer.Alignment getCommonIconAlignment(@NotNull List<MergeableLineMarkerInfo> infos) {
    return DEFAULT_GUTTER_ICON_ALIGNMENT;
  }

  @Override
  public Icon getCommonIcon(@NotNull List<MergeableLineMarkerInfo> infos) {
    Icon itemIcon = super.getCommonIcon(infos);
    LayeredIcon icon = JBUI.scale(new LayeredIcon(2));
    icon.setIcon(itemIcon, 0, 0, 0);
    icon.setIcon(AllIcons.General.DropdownGutter, 1, 0, 0);
    return icon;
  }
}
