/*
 * Copyright 2000-2013 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.spring.model;

import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.annotations.NotNull;

import java.util.Collections;
import java.util.List;

public class DefaultSpringBeanQualifier implements SpringQualifier {

  public static DefaultSpringBeanQualifier create(@NotNull CommonSpringBean bean) {
    return new DefaultSpringBeanQualifier(bean);
  }

  private final CommonSpringBean myBean;

  private DefaultSpringBeanQualifier(@NotNull CommonSpringBean bean) {
    myBean = bean;
  }

  @Override
  public boolean isValid() {
    return myBean.isValid();
  }

  @Override
  public XmlTag getXmlTag() {
    return null;
  }

  @Override
  public PsiManager getPsiManager() {
    return myBean.getPsiManager();
  }

  @Override
  public Module getModule() {
    return myBean.getModule();
  }

  @NotNull
  @Override
  public PsiElement getIdentifyingPsiElement() {
    final PsiElement psiElement = myBean.getIdentifyingPsiElement();
    assert psiElement != null : myBean;
    return psiElement;
  }

  @Override
  public PsiFile getContainingFile() {
    return myBean.getContainingFile();
  }

  @Override
  public PsiClass getQualifierType() {
    return null;
  }

  @Override
  public String getQualifierValue() {
    return myBean.getBeanName();
  }

  @NotNull
  @Override
  public List<? extends QualifierAttribute> getQualifierAttributes() {
    return Collections.emptyList();
  }
}
