// Copyright 2000-2018 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.model.converters;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.SmartList;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomJavaUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Collections;
import java.util.List;

/**
 * Do not use for "plain" references in {@link com.intellij.util.xml.Convert}, use {@link com.intellij.spring.model.xml.RequiredBeanType} instead.
 */
public abstract class SpringBeanResolveConverterForDefiniteClasses extends SpringBeanResolveConverter {

  @Nullable
  protected abstract String[] getClassNames(final ConvertContext context);

  @Override
  @NotNull
  public List<PsiClassType> getRequiredClasses(final ConvertContext context) {
    final String[] classNames = getClassNames(context);
    if (classNames == null || classNames.length == 0) return Collections.emptyList();

    final List<PsiClassType> required = new SmartList<>();
    for (String className : classNames) {
      final PsiClass psiClass = DomJavaUtil.findClass(className, context.getInvocationElement());
      if (psiClass != null) {
        required.add(PsiTypesUtil.getClassType(psiClass));
      }
    }
    return required;
  }
}
