/*
 * Copyright 2000-2013 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.spring.model.jam;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleServiceManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.model.jam.stereotype.SpringConfiguration;
import com.intellij.spring.model.jam.stereotype.SpringStereotypeElement;
import org.jetbrains.annotations.NotNull;

import java.util.List;

/**
 * @author Yann C&eacute;bron
 */
public abstract class SpringJamModel {

  public static SpringJamModel getModel(@NotNull Module module) {
    return ModuleServiceManager.getService(module, SpringJamModel.class);
  }

  @NotNull
  public abstract List<SpringStereotypeElement> getStereotypeComponents();

  @NotNull
  public abstract List<SpringStereotypeElement> getStereotypeComponents(@NotNull GlobalSearchScope scope);

  @NotNull
  public abstract List<SpringConfiguration> getConfigurations(@NotNull GlobalSearchScope scope);
}
