/*
 * Copyright 2000-2018 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.spring.model.jam.stereotype;

import com.intellij.ide.presentation.Presentation;
import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamClassMeta;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;
import com.intellij.semantic.SemKey;
import com.intellij.spring.constants.SpringAnnotationsConstants;
import com.intellij.spring.model.jam.JamPsiMemberSpringBean;
import com.intellij.spring.model.jam.utils.SpringJamUtils;
import com.intellij.util.Function;
import org.jetbrains.annotations.NotNull;

import java.util.Collection;

@Presentation(typeName = "@Configuration")
public class SpringConfiguration extends SpringMetaStereotypeComponent {

  public static final SemKey<JamMemberMeta<PsiClass, SpringConfiguration>> META_KEY =
    JamService.ALIASING_MEMBER_META_KEY.subKey("SpringConfigurationMeta");

  /**
   * @see com.intellij.spring.model.utils.SpringCommonUtils#isConfiguration(PsiClass)
   * @see com.intellij.spring.model.utils.SpringCommonUtils#isConfigurationOrMeta(PsiClass)
   */
  public static final SemKey<SpringConfiguration> JAM_KEY =
    JamPsiMemberSpringBean.PSI_MEMBER_SPRING_BEAN_JAM_KEY.subKey("SpringConfiguration");

  public static final JamClassMeta<SpringConfiguration> META =
    new JamClassMeta<>(null, SpringConfiguration.class, JAM_KEY);

  private static final Function<Module, Collection<String>> ANNOTATIONS =
    module -> getAnnotations(module, SpringAnnotationsConstants.JAVA_SPRING_CONFIGURATION);

  public SpringConfiguration(@NotNull PsiClass psiClass) {
    super(SpringAnnotationsConstants.JAVA_SPRING_CONFIGURATION, psiClass);
  }

  public SpringConfiguration(@NotNull String anno, @NotNull PsiClass psiClass) {
    super(anno, psiClass);
  }

  @NotNull
  public Collection<SpringPropertySource> getPropertySources() {
    return SpringJamUtils.getInstance().getPropertySources(getPsiElement());
  }

  @NotNull
  public static Function<Module, Collection<String>> getAnnotations() {
    return ANNOTATIONS;
  }
}
