/*
 * Copyright 2000-2016 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.spring.model.jam.stereotype;

import com.intellij.jam.JamElement;
import com.intellij.jam.annotations.JamPsiConnector;
import com.intellij.jam.annotations.JamPsiValidity;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.jam.reflect.JamAnnotationAttributeMeta;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamAttributeMeta;
import com.intellij.jam.reflect.JamClassMeta;
import com.intellij.psi.PsiClass;
import com.intellij.spring.constants.SpringAnnotationsConstants;
import org.jetbrains.annotations.NotNull;

import java.util.List;

public abstract class SpringJamComponentScans implements JamElement {
  public static final JamAnnotationAttributeMeta.Collection<SpringJamComponentScan> SCANS_ATTR =
    JamAttributeMeta.annoCollection("value", SpringJamComponentScan.ANNOTATION_META, SpringJamComponentScan.class);

  public static final JamAnnotationMeta ANNOTATION_META = new JamAnnotationMeta(SpringAnnotationsConstants.COMPONENT_SCANS).addAttribute(
    SCANS_ATTR);

  public static final JamClassMeta<SpringJamComponentScans> META = new JamClassMeta<>(SpringJamComponentScans.class).addAnnotation(ANNOTATION_META);

  @NotNull
  @JamPsiConnector
  public abstract PsiClass getPsiElement();

  @JamPsiValidity
  public abstract boolean isPsiValid();

  @NotNull
  public List<SpringJamComponentScan> getComponentScans() {
    return JamCommonUtil.getElementsIncludingSingle(getPsiElement(), ANNOTATION_META, SCANS_ATTR);
  }
}
