/*
 * Copyright 2000-2014 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.spring.model.xml.beans;

import com.intellij.psi.PsiClass;
import com.intellij.spring.constants.SpringConstants;
import com.intellij.spring.model.SpringQualifier;
import com.intellij.spring.model.converters.SpringDomQualifierTypeConverter;
import com.intellij.spring.model.xml.SpringModelElement;
import com.intellij.util.xml.Convert;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.NameValue;
import com.intellij.util.xml.Namespace;
import org.jetbrains.annotations.NotNull;

import java.util.List;

/**
 * @author Sergey.Vasiliev
 */
@Namespace(SpringConstants.BEANS_NAMESPACE_KEY)
public interface SpringDomQualifier extends SpringModelElement, SpringQualifier {

  @NotNull
  @NameValue
  GenericAttributeValue<String> getValue();

  @Convert(SpringDomQualifierTypeConverter.class)
  @NotNull
  GenericAttributeValue<PsiClass> getType();

  @NotNull
  List<SpringDomAttribute> getAttributes();
}