/*
 * Copyright 2000-2015 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated on Thu Nov 09 17:15:14 MSK 2006
// DTD/Schema  :    http://www.springframework.org/schema/util

package com.intellij.spring.model.xml.util;

import com.intellij.ide.presentation.Presentation;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.*;
import com.intellij.spring.model.values.converters.FieldRetrievingFactoryBeanConverter;
import com.intellij.spring.model.xml.BeanType;
import com.intellij.spring.model.xml.BeanTypeProvider;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.util.ArrayUtil;
import com.intellij.util.xml.*;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/**
 * http://www.springframework.org/schema/util:constantElemType interface.
 * @@updated: spring-util-4.1.xsd
 */
@Presentation(typeName = "Spring Constant")
@BeanType(provider = SpringConstant.SpringConstantBeanTypeProvider.class)
public interface SpringConstant extends SpringUtilElement, DomSpringBean {

  class SpringConstantBeanTypeProvider implements BeanTypeProvider<SpringConstant> {

    @NotNull
    @Override
    public String[] getBeanTypeCandidates() {
      return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    @Nullable
    @Override
    public String getBeanType(SpringConstant constant) {
      final PsiClass psiClass = getStaticFieldType(constant);
      return psiClass != null ? StringUtil.notNullize(psiClass.getQualifiedName()) : "";
    }

    @Nullable
    private static PsiClass getStaticFieldType(SpringConstant constant) {
      final GenericAttributeValue<String> staticField = constant.getStaticField();
      if (!DomUtil.hasXml(staticField)) {
        return null;
      }

      final ConverterManager converterManager = ServiceManager.getService(ConverterManager.class);
      final FieldRetrievingFactoryBeanConverter converter =
        (FieldRetrievingFactoryBeanConverter)converterManager.getConverterInstance(FieldRetrievingFactoryBeanConverter.class);

      PsiReference[] references = converter.createReferences(staticField, staticField.getXmlAttributeValue());
      if (references.length > 0) {
        PsiReference reference = references[references.length - 1];
        PsiElement element = reference.resolve();

        PsiType psiType = null;
        if (element instanceof PsiMethod) {
          psiType = ((PsiMethod)element).getReturnType();
        }
        else if (element instanceof PsiField) {
          psiType = ((PsiField)element).getType();
        }

        if (psiType instanceof PsiClassType) {
          return ((PsiClassType)psiType).resolve();
        }
      }
      return null;
    }
  }


  /**
   * Returns the value of the static-field child.
   *
   * @return the value of the static-field child.
   */
  @NotNull
  @Required
  @Referencing(value = FieldRetrievingFactoryBeanConverter.FieldReferenceRequired.class)
  GenericAttributeValue<String> getStaticField();
}
