/*
 * Copyright 2000-2007 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.javaee;

import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

/**
 * @author peter
 */
public class JavaeeCodeStyleSettings extends CustomCodeStyleSettings {
  public JavaeeCodeStyleSettings(CodeStyleSettings settings) {
    super("JavaeeCodeStyleSettings", settings);
  }

  @Override
  public void readExternal(Element parentElement) throws InvalidDataException {
    DefaultJDOMExternalizer.readExternal(this, getOurElement(parentElement));
  }

  private Element getOurElement(final Element parentElement) {
    final Element element = parentElement.getChild(getTagName());
    return element == null ? parentElement : element;
  }

  //----------------- EJB NAMING CONVENTIONS -------------
  @NonNls public String ENTITY_EB_PREFIX = "";         //EntityBean EJB Class name prefix
  @NonNls public String ENTITY_EB_SUFFIX = "Bean";     //EntityBean EJB Class name suffix
  @NonNls public String ENTITY_HI_PREFIX = "";         //EntityBean Home interface name prefix
  @NonNls public String ENTITY_HI_SUFFIX = "Home";     //EntityBean Home interface name suffix
  @NonNls public String ENTITY_RI_PREFIX = "";         //EntityBean Remote interface name prefix
  @NonNls public String ENTITY_RI_SUFFIX = "";         //EntityBean Remote interface name prefix
  @NonNls public String ENTITY_LHI_PREFIX = "Local";   //EntityBean local Home interface name prefix
  @NonNls public String ENTITY_LHI_SUFFIX = "Home";    //EntityBean local Home interface name suffix
  @NonNls public String ENTITY_LI_PREFIX = "Local";    //EntityBean local interface name prefix
  @NonNls public String ENTITY_LI_SUFFIX = "";         //EntityBean local interface name suffix
  @NonNls public String ENTITY_DD_PREFIX = "";         //EntityBean deployment descriptor name prefix
  @NonNls public String ENTITY_DD_SUFFIX = "EJB";      //EntityBean deployment descriptor name suffix
  @NonNls public String ENTITY_VO_PREFIX = "";
  @NonNls public String ENTITY_VO_SUFFIX = "VO";
  @NonNls public String ENTITY_PK_CLASS = "java.lang.String";

  @NonNls public String SESSION_EB_PREFIX = "";        //SessionBean EJB Class name prefix
  @NonNls public String SESSION_EB_SUFFIX = "Bean";    //SessionBean EJB Class name suffix
  @NonNls public String SESSION_HI_PREFIX = "";        //SessionBean Home interface name prefix
  @NonNls public String SESSION_HI_SUFFIX = "Home";    //SessionBean Home interface name suffix
  @NonNls public String SESSION_RI_PREFIX = "";        //SessionBean Remote interface name prefix
  @NonNls public String SESSION_RI_SUFFIX = "";        //SessionBean Remote interface name prefix
  @NonNls public String SESSION_LHI_PREFIX = "Local";  //SessionBean local Home interface name prefix
  @NonNls public String SESSION_LHI_SUFFIX = "Home";   //SessionBean local Home interface name suffix
  @NonNls public String SESSION_LI_PREFIX = "Local";   //SessionBean local interface name prefix
  @NonNls public String SESSION_LI_SUFFIX = "";        //SessionBean local interface name suffix
  @NonNls public String SESSION_SI_PREFIX = "";   //SessionBean service endpoint interface name prefix
  @NonNls public String SESSION_SI_SUFFIX = "Service";        //SessionBean service endpoint interface name suffix
  @NonNls public String SESSION_DD_PREFIX = "";        //SessionBean deployment descriptor name prefix
  @NonNls public String SESSION_DD_SUFFIX = "EJB";     //SessionBean deployment descriptor name suffix

  @NonNls public String MESSAGE_EB_PREFIX = "";        //MessageBean EJB Class name prefix
  @NonNls public String MESSAGE_EB_SUFFIX = "Bean";    //MessageBean EJB Class name suffix
  @NonNls public String MESSAGE_DD_PREFIX = "";        //MessageBean deployment descriptor name prefix
  @NonNls public String MESSAGE_DD_SUFFIX = "EJB";     //MessageBean deployment descriptor name suffix
  //----------------- Servlet NAMING CONVENTIONS -------------
  @NonNls public String SERVLET_CLASS_PREFIX = "";           //SERVLET Class name prefix
  @NonNls public String SERVLET_CLASS_SUFFIX = "";           //SERVLET Class name suffix
  @NonNls public String SERVLET_DD_PREFIX = "";              //SERVLET deployment descriptor name prefix
  @NonNls public String SERVLET_DD_SUFFIX = "";              //SERVLET deployment descriptor name suffix
  //----------------- Web Filter NAMING CONVENTIONS -------------
  @NonNls public String FILTER_CLASS_PREFIX = "";          //Filter Class name prefix
  @NonNls public String FILTER_CLASS_SUFFIX = "";          //Filter Class name suffix
  @NonNls public String FILTER_DD_PREFIX = "";             //Filter deployment descriptor name prefix
  @NonNls public String FILTER_DD_SUFFIX = "";             //Filter deployment descriptor name suffix

  @NonNls public String LISTENER_CLASS_PREFIX = "";          //Listener Class name prefix
  @NonNls public String LISTENER_CLASS_SUFFIX = "";          //Listener Class name suffix

}
