/*
 * Copyright 2000-2007 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.javaee.ejb.role;

import com.intellij.javaee.model.common.ejb.EnterpriseBean;
import com.intellij.javaee.model.common.ejb.Interceptor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import org.jetbrains.annotations.Nullable;

import javax.swing.*;

/**
 * @author peter
 */
public interface EjbClassRole extends EjbRole {
  EjbClassRoleEnum getType();

  @Override
  EnterpriseBean getEnterpriseBean();

  @Nullable
  Interceptor getInterceptor();

  EjbMethodRole getMethodRole(PsiMethod method);

  boolean isDeclarationRole();

  PsiClass[] findImplementations();

  String getTitle();

  boolean isRemote();

  Icon getIcon();
}
