package com.intellij.javaee.module;

import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.facet.JavaeeFacetUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.util.descriptors.ConfigFile;
import com.intellij.util.descriptors.ConfigFileContainer;
import com.intellij.util.xml.ModuleContextProvider;
import org.jetbrains.annotations.NotNull;

import java.util.HashSet;
import java.util.Set;

public class JavaeeModuleContextProvider extends ModuleContextProvider {

  @NotNull
  @Override
  public Module[] getContextModules(@NotNull PsiFile context) {
    Project project = context.getProject();
    Set<Module> modules = new HashSet<>();
    for (JavaeeFacet javaeeFacet : JavaeeFacetUtil.getInstance().getAllJavaeeFacets(project)) {
      ConfigFileContainer descriptorsContainer = javaeeFacet.getDescriptorsContainer();
      if (descriptorsContainer != null) {
        for (ConfigFile file : descriptorsContainer.getConfigFiles()) {
          if (context.equals(file.getPsiFile())) {
            modules.add(javaeeFacet.getModule());
          }
        }
      }
    }

    return modules.toArray(Module.EMPTY_ARRAY);
  }
}
