/*
 * Copyright 2000-2007 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.javaee.run.configuration;

import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.appServerIntegrations.AppServerIntegration;
import com.intellij.javaee.appServerIntegrations.ApplicationServer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import javax.swing.*;
import java.util.Arrays;
import java.util.List;

public abstract class J2EEConfigurationType implements ConfigurationType {
  private final NotNullLazyValue<ConfigurationFactory[]> myFactories =
    NotNullLazyValue.createValue(() -> ArrayUtil.toObjectArray(computeFactories(), ConfigurationFactory.class));

  @NotNull
  private final String myId;

  protected J2EEConfigurationType(@NotNull String id) {
    myId = id;
  }

  /**
   * @deprecated Use {@link #J2EEConfigurationType(String)}
   */
  @Deprecated
  protected J2EEConfigurationType() {
    myId = "";
  }

  // todo make final (backward compatibility)
  @NotNull
  @Override
  public String getId() {
    return myId;
  }

  @NotNull
  protected List<ConfigurationFactory> computeFactories() {
    return Arrays.asList(
      createLocalFactory(),
      createFactory(false, "run.configuration.remote")
    );
  }

  @NotNull
  private ConfigurationFactory createFactory(boolean isLocal, @NotNull String nameKey) {
    return J2EEConfigurationFactory.getInstance().createFactory(this, isLocal, J2EEBundle.message(nameKey));
  }

  @NotNull
  protected final ConfigurationFactory createLocalFactory() {
    return createFactory(true, "run.configuration.local");
  }

  // todo make final (backward compatibility)
  @NotNull
  public ConfigurationFactory getLocalFactory() {
    return myFactories.getValue()[0];
  }

  protected abstract RunConfiguration createJ2EEConfigurationTemplate(ConfigurationFactory factory, Project project, boolean isLocal);

  // todo make final (backward compatibility)
  @Override
  public ConfigurationFactory[] getConfigurationFactories() {
    return myFactories.getValue();
  }

  @Nullable
  public AppServerIntegration getIntegration() {
    return null;
  }

  @Nullable
  @NonNls
  public String getUrlToOpenInBrowser(@NotNull ApplicationServer server, @NotNull PsiFile psiFile) {
    return null;
  }

  @NotNull
  public Icon getLocalIcon() {
    return getIcon();
  }

  @NotNull
  public Icon getRemoteIcon() {
    return getIcon();
  }
}
