/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.workload;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.trogdor.common.Topology;
import org.apache.kafka.trogdor.task.TaskController;
import org.apache.kafka.trogdor.task.TaskSpec;
import org.apache.kafka.trogdor.task.TaskWorker;
import org.apache.kafka.trogdor.workload.ProduceBenchWorker;

public class ProduceBenchSpec
extends TaskSpec {
    private final String producerNode;
    private final String bootstrapServers;
    private final int targetMessagesPerSec;
    private final int maxMessages;
    private final Map<String, String> producerConf;
    private final int totalTopics;
    private final int activeTopics;

    @JsonCreator
    public ProduceBenchSpec(@JsonProperty(value="startMs") long startMs, @JsonProperty(value="durationMs") long durationMs, @JsonProperty(value="producerNode") String producerNode, @JsonProperty(value="bootstrapServers") String bootstrapServers, @JsonProperty(value="targetMessagesPerSec") int targetMessagesPerSec, @JsonProperty(value="maxMessages") int maxMessages, @JsonProperty(value="producerConf") Map<String, String> producerConf, @JsonProperty(value="totalTopics") int totalTopics, @JsonProperty(value="activeTopics") int activeTopics) {
        super(startMs, durationMs);
        this.producerNode = producerNode;
        this.bootstrapServers = bootstrapServers;
        this.targetMessagesPerSec = targetMessagesPerSec;
        this.maxMessages = maxMessages;
        this.producerConf = producerConf;
        this.totalTopics = totalTopics;
        this.activeTopics = activeTopics;
    }

    @JsonProperty
    public String producerNode() {
        return this.producerNode;
    }

    @JsonProperty
    public String bootstrapServers() {
        return this.bootstrapServers;
    }

    @JsonProperty
    public int targetMessagesPerSec() {
        return this.targetMessagesPerSec;
    }

    @JsonProperty
    public int maxMessages() {
        return this.maxMessages;
    }

    @JsonProperty
    public Map<String, String> producerConf() {
        return this.producerConf;
    }

    @JsonProperty
    public int totalTopics() {
        return this.totalTopics;
    }

    @JsonProperty
    public int activeTopics() {
        return this.activeTopics;
    }

    @Override
    public TaskController newController(String id) {
        return new TaskController(){

            @Override
            public Set<String> targetNodes(Topology topology) {
                return Collections.singleton(ProduceBenchSpec.this.producerNode);
            }
        };
    }

    @Override
    public TaskWorker newTaskWorker(String id) {
        return new ProduceBenchWorker(id, this);
    }
}

