<?php

namespace Geeklog\Text\Wiki;

    /**
     * Parses for horizontal ruling lines.
     *
     * @category Text
     * @package  Text_Wiki
     * @author   Paul M. Jones <pmjones@php.net>
     * @license  LGPL
     * @version  $Id: Horiz.php 180591 2005-02-23 17:38:29Z pmjones $
     */

/**
 * Parses for horizontal ruling lines.
 * This class implements a Text_Wiki_Parse to find source text marked to
 * be a horizontal rule, as defined by four dashed on their own line.
 *
 * @category Text
 * @package  Text_Wiki
 * @author   Paul M. Jones <pmjones@php.net>
 */
class Text_Wiki_Parse_Horiz extends Text_Wiki_Parse
{
    /**
     * The regular expression used to parse the source text and find
     * matches conforming to this rule.  Used by the parse() method.
     *
     * @var string
     * @see    parse()
     */
    public $regex = '/^([-]{4,})$/m';

    /**
     * Generates a replacement token for the matched text.
     *
     * @param  array &$matches The array of matches from parse().
     * @return string A token marking the horizontal rule.
     */
    public function process(&$matches)
    {
        return $this->wiki->addToken($this->rule);
    }
}
