/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.replace.impl;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.structuralsearch.MalformedPatternException;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.impl.matcher.MatcherImplUtil;
import com.intellij.structuralsearch.impl.matcher.PatternTreeContext;
import com.intellij.structuralsearch.impl.matcher.predicates.ScriptSupport;
import com.intellij.structuralsearch.plugin.replace.ReplaceOptions;
import com.intellij.structuralsearch.plugin.replace.ReplacementInfo;
import com.intellij.structuralsearch.plugin.replace.impl.ParameterInfo;
import com.intellij.structuralsearch.plugin.replace.impl.Replacer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public final class ReplacementBuilder {
    private final String d;
    private final List<ParameterInfo> a = new SmartList();
    private final Map<String, ScriptSupport> e = new HashMap<String, ScriptSupport>();
    private final ReplaceOptions b;
    private final Project c;

    ReplacementBuilder(Project project, ReplaceOptions options) {
        ParameterInfo parameterInfo;
        PsiElement[] psiElementArray;
        this.c = project;
        this.b = options;
        Template template = TemplateManager.getInstance((Project)project).createTemplate("", "", options.getReplacement());
        this.d = template.getTemplateText();
        int n2 = 0;
        for (int i10 = 0; i10 < template.getSegmentsCount(); ++i10) {
            int n3;
            int n4 = template.getSegmentOffset(i10);
            parameterInfo = new ParameterInfo((String)psiElementArray, n4, options.getVariableDefinition((String)(psiElementArray = template.getSegmentName(i10))) != null);
            for (n3 = n4 - 1; n3 >= n2 && n3 < this.d.length() && StringUtil.isWhiteSpace((char)this.d.charAt(n3)); --n3) {
            }
            if (n3 >= 0) {
                if (this.d.charAt(n3) == ',') {
                    parameterInfo.setHasCommaBefore(true);
                }
                while (n3 > n2 && StringUtil.isWhiteSpace((char)this.d.charAt(n3 - 1))) {
                    --n3;
                }
                parameterInfo.setBeforeDelimiterPos(n3);
            }
            for (n3 = n4; n3 < this.d.length() && StringUtil.isWhiteSpace((char)this.d.charAt(n3)); ++n3) {
            }
            if (n3 < this.d.length()) {
                char c10 = this.d.charAt(n3);
                if (c10 == ';') {
                    parameterInfo.setStatementContext(true);
                } else if (c10 == ',' || c10 == ')') {
                    parameterInfo.setArgumentContext(true);
                    parameterInfo.setHasCommaAfter(c10 == ',');
                }
            }
            parameterInfo.setAfterDelimiterPos(n3);
            n2 = n4;
            this.a.add(parameterInfo);
        }
        FileType fileType = options.getMatchOptions().getFileType();
        StructuralSearchProfile structuralSearchProfile = StructuralSearchUtil.getProfileByFileType(fileType);
        if (structuralSearchProfile != null) {
            try {
                psiElementArray = MatcherImplUtil.createTreeFromText(options.getReplacement(), PatternTreeContext.Block, fileType, options.getMatchOptions().getDialect(), options.getMatchOptions().getPatternContext(), project, false);
                if (psiElementArray.length > 0) {
                    parameterInfo = psiElementArray[0].getParent();
                    parameterInfo.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

                        public void visitElement(PsiElement element) {
                            ParameterInfo parameterInfo;
                            super.visitElement(element);
                            String string = element.getText();
                            if (StructuralSearchUtil.isTypedVariable(string) && (parameterInfo = ReplacementBuilder.this.findParameterization(Replacer.stripTypedVariableDecoration(string))) != null && parameterInfo.getElement() == null) {
                                parameterInfo.setElement(element);
                            }
                        }
                    });
                    structuralSearchProfile.provideAdditionalReplaceOptions((PsiElement)parameterInfo, options, this);
                }
            }
            catch (IncorrectOperationException incorrectOperationException) {
                throw new MalformedPatternException(incorrectOperationException.getMessage());
            }
        }
    }

    String process(MatchResult match, ReplacementInfo replacementInfo, FileType type) {
        if (this.a.isEmpty()) {
            return this.d;
        }
        StringBuilder stringBuilder = new StringBuilder(this.d);
        StructuralSearchProfile structuralSearchProfile = StructuralSearchUtil.getProfileByFileType(type);
        assert (structuralSearchProfile != null);
        int n2 = 0;
        for (ParameterInfo parameterInfo : this.a) {
            MatchResult matchResult = replacementInfo.getNamedMatchResult(parameterInfo.getName());
            if (parameterInfo.isReplacementVariable()) {
                n2 = Replacer.insertSubstitution(stringBuilder, n2, parameterInfo, this.a(parameterInfo, match));
                continue;
            }
            if (matchResult != null) {
                n2 = structuralSearchProfile.handleSubstitution(parameterInfo, matchResult, stringBuilder, n2, replacementInfo);
                continue;
            }
            n2 = structuralSearchProfile.handleNoSubstitution(parameterInfo, n2, stringBuilder);
        }
        return stringBuilder.toString();
    }

    private String a(ParameterInfo parameterInfo, MatchResult matchResult) {
        ScriptSupport scriptSupport = this.e.get(parameterInfo.getName());
        if (scriptSupport == null) {
            String string = this.b.getVariableDefinition(parameterInfo.getName()).getScriptCodeConstraint();
            List<String> list2 = this.b.getVariableDefinitions().stream().map(replacementVariableDefinition -> replacementVariableDefinition.getName()).collect(Collectors.toList());
            scriptSupport = new ScriptSupport(this.c, StringUtil.unquoteString((String)string), parameterInfo.getName(), list2);
            this.e.put(parameterInfo.getName(), scriptSupport);
        }
        return scriptSupport.evaluate(matchResult, null);
    }

    @Nullable
    public ParameterInfo findParameterization(String name) {
        for (ParameterInfo parameterInfo : this.a) {
            if (!parameterInfo.getName().equals(name)) continue;
            return parameterInfo;
        }
        return null;
    }
}

