/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.zend.debugger.valueModel;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.debug.PhpDebugUtil;
import com.jetbrains.php.debug.TypeInfo;
import com.jetbrains.php.debug.zend.debugger.valueModel.ZendDebuggerExpression;
import com.jetbrains.php.debug.zend.debugger.valueModel.ZendDebuggerExpressionImpl;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ZendDebuggerExpressionValue
implements TypeInfo {
    public static final ZendDebuggerExpression[] EMPTY_EXPRESSION_ARRAY = new ZendDebuggerExpression[0];
    public static final int NULL_TYPE = 0;
    public static final int INT_TYPE = 1;
    public static final int STRING_TYPE = 2;
    public static final int BOOLEAN_TYPE = 3;
    public static final int DOUBLE_TYPE = 4;
    public static final int ARRAY_TYPE = 5;
    public static final int OBJECT_TYPE = 6;
    public static final int RESOURCE_TYPE = 7;
    public static final ZendDebuggerExpressionValue NULL_VALUE = new ZendDebuggerExpressionValue(0, null, null, "null");
    protected int type;
    protected ZendDebuggerExpression[] myChildren;
    protected int myChildrenCount;
    protected Object myValue;
    protected String myValueAsString;
    protected final String myTypeAsString;

    public ZendDebuggerExpressionValue(int type, String typeAsString, Object value, String valueAsString, ZendDebuggerExpression[] children, int childrenCount) {
        this.type = type;
        this.myValue = value;
        this.myValueAsString = valueAsString;
        this.myChildren = children;
        this.myChildrenCount = childrenCount;
        this.myTypeAsString = typeAsString;
    }

    public ZendDebuggerExpressionValue(int type, String typeAsString, Object value, String valueAsString) {
        this(type, typeAsString, value, valueAsString, EMPTY_EXPRESSION_ARRAY, 0);
    }

    public int getType() {
        return this.type;
    }

    public String getTypeAsString() {
        return this.myTypeAsString;
    }

    public Object getValue() {
        return this.myValue;
    }

    public String getValueAsString() {
        return this.myValueAsString;
    }

    public boolean isObject() {
        return this.type == 6;
    }

    public boolean isArray() {
        return this.type == 5;
    }

    @Override
    public boolean isNull() {
        return this.type == 0;
    }

    @Override
    public boolean isBoolean() {
        return this.type == 3;
    }

    public boolean isPrimitive() {
        switch (this.type) {
            case 5: 
            case 6: 
            case 7: {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isString() {
        return this.type == 2;
    }

    @Override
    public boolean isNumber() {
        return this.type == 1 || this.type == 4;
    }

    public boolean isFullyLoaded() {
        return this.myChildrenCount == this.myChildren.length;
    }

    public ZendDebuggerExpression[] getChildren() {
        return this.myChildren;
    }

    public int getChildrenCount() {
        return this.myChildrenCount;
    }

    @NotNull
    public static Icon getIcon(@NotNull ZendDebuggerExpressionValue value) {
        if (value == null) {
            ZendDebuggerExpressionValue.$$$reportNull$$$0(0);
        }
        switch (value.getType()) {
            case 5: {
                Icon icon = AllIcons.Debugger.Db_array;
                if (icon == null) {
                    ZendDebuggerExpressionValue.$$$reportNull$$$0(1);
                }
                return icon;
            }
            case 6: {
                Icon icon = AllIcons.Debugger.Value;
                if (icon == null) {
                    ZendDebuggerExpressionValue.$$$reportNull$$$0(2);
                }
                return icon;
            }
        }
        Icon icon = AllIcons.Debugger.Db_primitive;
        if (icon == null) {
            ZendDebuggerExpressionValue.$$$reportNull$$$0(3);
        }
        return icon;
    }

    public static ZendDebuggerExpressionValue deserialize(@NotNull Project project, ZendDebuggerExpression expression, String value) {
        if (project == null) {
            ZendDebuggerExpressionValue.$$$reportNull$$$0(4);
        }
        return ZendDebuggerExpressionValue.deserialize(project, expression, value.getBytes());
    }

    public static ZendDebuggerExpressionValue deserialize(@NotNull Project project, @Nullable ZendDebuggerExpression expression, byte[] value) {
        if (project == null) {
            ZendDebuggerExpressionValue.$$$reportNull$$$0(5);
        }
        if (value == null) {
            value = new byte[]{78};
        }
        return ZendDebuggerExpressionValue.build(expression, new VariableReader(project, value));
    }

    public static ZendDebuggerExpressionValue build(@Nullable ZendDebuggerExpression expression, @NotNull VariableReader reader) {
        if (reader == null) {
            ZendDebuggerExpressionValue.$$$reportNull$$$0(6);
        }
        char type = reader.readType();
        switch (type) {
            case 'i': {
                return ZendDebuggerExpressionValue.buildIntType(reader);
            }
            case 'd': {
                return ZendDebuggerExpressionValue.buildDoubleType(reader);
            }
            case 's': {
                return ZendDebuggerExpressionValue.buildStringType(reader);
            }
            case 'b': {
                return ZendDebuggerExpressionValue.buildBooleanType(reader);
            }
            case 'r': {
                return ZendDebuggerExpressionValue.buildResourceType(reader);
            }
            case 'a': {
                return ZendDebuggerExpressionValue.buildArrayType(expression, reader);
            }
            case 'O': {
                return ZendDebuggerExpressionValue.buildObjectType(expression, reader);
            }
        }
        return NULL_VALUE;
    }

    public static ZendDebuggerExpressionValue buildIntType(@NotNull VariableReader reader) {
        if (reader == null) {
            ZendDebuggerExpressionValue.$$$reportNull$$$0(7);
        }
        String value = reader.readToken();
        return new ZendDebuggerExpressionValue(1, "integer", value, value);
    }

    public static ZendDebuggerExpressionValue buildDoubleType(@NotNull VariableReader reader) {
        if (reader == null) {
            ZendDebuggerExpressionValue.$$$reportNull$$$0(8);
        }
        String value = reader.readToken();
        return new ZendDebuggerExpressionValue(4, "double", value, value);
    }

    public static ZendDebuggerExpressionValue buildStringType(@NotNull VariableReader reader) {
        if (reader == null) {
            ZendDebuggerExpressionValue.$$$reportNull$$$0(9);
        }
        String value = reader.readString();
        return new ZendDebuggerExpressionValue(2, "string", value, value);
    }

    public static ZendDebuggerExpressionValue buildBooleanType(@NotNull VariableReader reader) {
        String value;
        if (reader == null) {
            ZendDebuggerExpressionValue.$$$reportNull$$$0(10);
        }
        String valueAsString = (value = reader.readToken()).equals("0") ? "false" : "true";
        return new ZendDebuggerExpressionValue(3, "bool", value, valueAsString);
    }

    public static ZendDebuggerExpressionValue buildResourceType(@NotNull VariableReader reader) {
        if (reader == null) {
            ZendDebuggerExpressionValue.$$$reportNull$$$0(11);
        }
        int resourceNumber = reader.readInt();
        reader.readInt();
        String value = reader.readToken();
        String valueAsString = "resource id='" + resourceNumber + "' type='" + value + "'";
        return new ZendDebuggerExpressionValue(7, "resource", value, valueAsString);
    }

    public static ZendDebuggerExpressionValue buildArrayType(@Nullable ZendDebuggerExpression expression, @NotNull VariableReader reader) {
        int objectLength;
        if (reader == null) {
            ZendDebuggerExpressionValue.$$$reportNull$$$0(12);
        }
        int originalLength = objectLength = reader.readInt();
        if (reader.isLastEnd()) {
            objectLength = 0;
        }
        ZendDebuggerExpression[] variableNodes = new ZendDebuggerExpression[objectLength];
        for (int i = 0; i < objectLength; ++i) {
            String name;
            char type = reader.readType();
            boolean isInteger = type == 'i';
            String string = name = isInteger ? Integer.toString(reader.readInt()) : reader.readString();
            if (expression == null) {
                variableNodes[i] = ZendDebuggerExpressionValue.createDefaultVariable(name);
            } else {
                String endRepresentation = '[' + (isInteger ? name : (String)StringUtil.SINGLE_QUOTER.fun((Object)name)) + ']';
                variableNodes[i] = expression.createChildExpression(name, name, endRepresentation);
            }
            variableNodes[i].setValue(ZendDebuggerExpressionValue.build(expression, reader));
        }
        String valueAsString = PhpBundle.message("debug.composite.value.presentation", originalLength);
        return new ZendDebuggerExpressionValue(5, "array", "", valueAsString, variableNodes, originalLength);
    }

    public static ZendDebuggerExpressionValue buildObjectType(@Nullable ZendDebuggerExpression expression, @NotNull VariableReader reader) {
        int objectLength;
        if (reader == null) {
            ZendDebuggerExpressionValue.$$$reportNull$$$0(13);
        }
        String objectName = reader.readString();
        int originalLength = objectLength = reader.readInt();
        if (reader.isLastEnd()) {
            objectLength = 0;
        }
        ZendDebuggerExpression[] expressionNodes = new ZendDebuggerExpression[objectLength];
        for (int i = 0; i < objectLength; ++i) {
            char type = reader.readType();
            String name = type == 'i' ? Integer.toString(reader.readInt()) : reader.readString();
            if (expression == null) {
                expressionNodes[i] = ZendDebuggerExpressionValue.createDefaultVariable(name);
            } else {
                String fieldName = name.substring(name.lastIndexOf(58) + 1);
                expressionNodes[i] = expression.createChildExpression(name, fieldName, "->" + fieldName);
            }
            expressionNodes[i].setValue(ZendDebuggerExpressionValue.build(expression, reader));
        }
        String valueAsString = PhpBundle.message("debug.composite.value.presentation", originalLength);
        return new ZendDebuggerExpressionValue(6, objectName, objectName, valueAsString, expressionNodes, originalLength);
    }

    public static ZendDebuggerExpression createDefaultVariable(String name) {
        return new ZendDebuggerExpressionImpl('$' + name, name);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/zend/debugger/valueModel/ZendDebuggerExpressionValue";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/zend/debugger/valueModel/ZendDebuggerExpressionValue";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "buildIntType";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "buildDoubleType";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "buildStringType";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "buildBooleanType";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "buildResourceType";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "buildArrayType";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "buildObjectType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class VariableReader
    extends ByteArrayInputStream {
        private final Project myProject;

        private VariableReader(@NotNull Project project, byte[] result) {
            if (project == null) {
                VariableReader.$$$reportNull$$$0(0);
            }
            super(result);
            this.myProject = project;
        }

        private char readType() {
            int temp;
            char curr;
            do {
                if ((temp = super.read()) != -1) continue;
                return ' ';
            } while ((curr = (char)temp) == ';' || curr == ':' || curr == '{' || curr == '}');
            return curr;
        }

        private String readToken() {
            char curr;
            StringBuilder buffer = new StringBuilder(6);
            while ((curr = (char)super.read()) == ';' || curr == ':') {
            }
            while (curr != ';' && curr != ':') {
                buffer.append(curr);
                curr = (char)super.read();
            }
            return buffer.toString();
        }

        private String readString() {
            int length = this.readInt();
            assert (length > -1) : "Length: " + length + ", pos:" + this.pos + " in " + new String(this.buf);
            while ((char)super.read() != '\"') {
            }
            byte[] bytes = new byte[length];
            this.read(bytes, 0, length);
            super.read();
            return this.getText(bytes);
        }

        public int readInt() {
            char curr;
            int result = 0;
            boolean isMinus = false;
            do {
                if ((curr = (char)super.read()) != '-') continue;
                isMinus = true;
            } while (!Character.isDigit(curr));
            do {
                result *= 10;
                result += Character.getNumericValue(curr);
                this.mark(1);
            } while (Character.isDigit(curr = (char)super.read()));
            if (isMinus) {
                result *= -1;
            }
            return result;
        }

        private boolean isLastEnd() {
            this.reset();
            char curr = (char)super.read();
            return curr == ';';
        }

        private String getText(byte[] buf) {
            try {
                return new String(buf, PhpDebugUtil.getDebugOutputEncoding(this.myProject));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return new String(buf);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/php/debug/zend/debugger/valueModel/ZendDebuggerExpressionValue$VariableReader", "<init>"));
        }
    }
}

