/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.highlighter;

import com.intellij.lang.Language;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.php.lang.PhpLanguage;
import com.jetbrains.php.lang.highlighter.PhpFileSyntaxHighlighter;
import com.jetbrains.php.lang.highlighter.PhpHighlightingData;
import com.jetbrains.php.lang.highlighter.PhpHighlightingLexer;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PhpColorPageHighlighter
extends PhpFileSyntaxHighlighter {
    private static final IElementType INTERFACE = new HighlightingType("interface");
    private static final IElementType STATIC_METHOD_CALL = new HighlightingType("static_method_call");
    private static final IElementType INSTANCE_METHOD_CALL = new HighlightingType("instance_method_call");
    private static final IElementType MAGIC_MEMBER = new HighlightingType("magic_member");
    private static final IElementType STATIC_FIELD = new HighlightingType("static_field");
    private static final IElementType VAR_VAR = new HighlightingType("var_var");
    private static final IElementType ALIAS_REFERENCE = new HighlightingType("alias_reference");
    private static final List<TokenPattern> PATTERNS = new ArrayList<TokenPattern>();
    private static final Map<IElementType, TextAttributesKey[]> ATTRIBUTE_MAP;

    private static TextAttributesKey[] phpScript(@NotNull TextAttributesKey key) {
        if (key == null) {
            PhpColorPageHighlighter.$$$reportNull$$$0(0);
        }
        return PhpColorPageHighlighter.pack((TextAttributesKey)PhpHighlightingData.PHP_SCRIPTING, (TextAttributesKey)key);
    }

    public PhpColorPageHighlighter(@NotNull Map<Integer, IElementType> typeMap) {
        if (typeMap == null) {
            PhpColorPageHighlighter.$$$reportNull$$$0(1);
        }
        super((Lexer)new ColorPageLexer(typeMap));
    }

    static Map<Integer, IElementType> buildTypeMap(@NotNull String sample) {
        if (sample == null) {
            PhpColorPageHighlighter.$$$reportNull$$$0(2);
        }
        HashMap<Integer, IElementType> typeMap = new HashMap<Integer, IElementType>();
        for (TokenPattern pattern : PATTERNS) {
            int patternOffset;
            int searchOffset = 0;
            if (pattern.patternText.length() <= 0) continue;
            while ((patternOffset = sample.indexOf(pattern.patternText, searchOffset)) >= 0) {
                int tokenOffset = sample.indexOf(pattern.tokenText, patternOffset);
                if (tokenOffset >= 0 && tokenOffset < patternOffset + pattern.patternText.length()) {
                    typeMap.put(tokenOffset, pattern.mappedType);
                }
                searchOffset = patternOffset + pattern.patternText.length();
            }
        }
        return typeMap;
    }

    @Override
    @NotNull
    public TextAttributesKey[] getTokenHighlights(IElementType tokenType) {
        if (ATTRIBUTE_MAP.containsKey(tokenType)) {
            TextAttributesKey[] textAttributesKeyArray = ATTRIBUTE_MAP.get(tokenType);
            if (textAttributesKeyArray == null) {
                PhpColorPageHighlighter.$$$reportNull$$$0(3);
            }
            return textAttributesKeyArray;
        }
        TextAttributesKey[] textAttributesKeyArray = super.getTokenHighlights(tokenType);
        if (textAttributesKeyArray == null) {
            PhpColorPageHighlighter.$$$reportNull$$$0(4);
        }
        return textAttributesKeyArray;
    }

    static {
        PATTERNS.add(new TokenPattern("foo", "function foo", (IElementType)PhpStubElementTypes.FUNCTION));
        PATTERNS.add(new TokenPattern("doSmth", "function doSmth", (IElementType)PhpStubElementTypes.FUNCTION));
        PATTERNS.add(new TokenPattern("foo", "foo();", PhpElementTypes.FUNCTION_CALL));
        PATTERNS.add(new TokenPattern("self", "self", PhpTokenTypes.kwNEW));
        PATTERNS.add(new TokenPattern("CONSTANT", "CONSTANT", PhpElementTypes.CONSTANTS));
        PATTERNS.add(new TokenPattern("SomeClass", "SomeClass", (IElementType)PhpStubElementTypes.CLASS));
        PATTERNS.add(new TokenPattern("SomeAlias", "new SomeAlias();", ALIAS_REFERENCE));
        PATTERNS.add(new TokenPattern("Another", "interface Another", INTERFACE));
        PATTERNS.add(new TokenPattern("convert", "Helper::convert", STATIC_METHOD_CALL));
        PATTERNS.add(new TokenPattern("invent", "$this->invent", INSTANCE_METHOD_CALL));
        PATTERNS.add(new TokenPattern("magic", "self::magic", MAGIC_MEMBER));
        PATTERNS.add(new TokenPattern("$my", "private $my", PhpElementTypes.CLASS_FIELDS));
        PATTERNS.add(new TokenPattern("result", "$q->result", PhpElementTypes.CLASS_FIELDS));
        PATTERNS.add(new TokenPattern("$shared", "$shared", STATIC_FIELD));
        PATTERNS.add(new TokenPattern("$abc", "$abc", (IElementType)PhpStubElementTypes.PARAMETER));
        PATTERNS.add(new TokenPattern("$def", "$def", (IElementType)PhpStubElementTypes.PARAMETER));
        PATTERNS.add(new TokenPattern("Label", "Label:", PhpElementTypes.GOTO_LABEL));
        PATTERNS.add(new TokenPattern("$", "$$def", VAR_VAR));
        PATTERNS.add(new TokenPattern("\u2116", "\u2116", TokenType.BAD_CHARACTER));
        PATTERNS.add(new TokenPattern("Helper", "Helper::", (IElementType)PhpStubElementTypes.CLASS));
        PATTERNS.add(new TokenPattern("__FILE__", "__FILE__", PhpElementTypes.CONSTANTS));
        ATTRIBUTE_MAP = new HashMap<IElementType, TextAttributesKey[]>();
        ATTRIBUTE_MAP.put((IElementType)PhpStubElementTypes.FUNCTION, PhpColorPageHighlighter.phpScript(PhpHighlightingData.FUNCTION));
        ATTRIBUTE_MAP.put(PhpElementTypes.FUNCTION_CALL, PhpColorPageHighlighter.phpScript(PhpHighlightingData.FUNCTION_CALL));
        ATTRIBUTE_MAP.put(PhpElementTypes.CONSTANTS, PhpColorPageHighlighter.phpScript(PhpHighlightingData.CONSTANT));
        ATTRIBUTE_MAP.put((IElementType)PhpStubElementTypes.CLASS, PhpColorPageHighlighter.phpScript(PhpHighlightingData.CLASS));
        ATTRIBUTE_MAP.put(INTERFACE, PhpColorPageHighlighter.phpScript(PhpHighlightingData.INTERFACE));
        ATTRIBUTE_MAP.put(STATIC_METHOD_CALL, PhpColorPageHighlighter.phpScript(PhpHighlightingData.STATIC_METHOD_CALL));
        ATTRIBUTE_MAP.put(INSTANCE_METHOD_CALL, PhpColorPageHighlighter.phpScript(PhpHighlightingData.INSTANCE_METHOD_CALL));
        ATTRIBUTE_MAP.put(PhpElementTypes.CLASS_FIELDS, PhpColorPageHighlighter.phpScript(PhpHighlightingData.INSTANCE_FIELD));
        ATTRIBUTE_MAP.put(MAGIC_MEMBER, PhpColorPageHighlighter.phpScript(PhpHighlightingData.MAGIC_MEMBER_ACCESS));
        ATTRIBUTE_MAP.put(STATIC_FIELD, PhpColorPageHighlighter.phpScript(PhpHighlightingData.STATIC_FIELD));
        ATTRIBUTE_MAP.put(ALIAS_REFERENCE, PhpColorPageHighlighter.phpScript(PhpHighlightingData.ALIAS_REFERENCE));
        ATTRIBUTE_MAP.put((IElementType)PhpStubElementTypes.PARAMETER, PhpColorPageHighlighter.phpScript(PhpHighlightingData.PARAMETER));
        ATTRIBUTE_MAP.put(PhpElementTypes.GOTO_LABEL, PhpColorPageHighlighter.phpScript(PhpHighlightingData.GOTO_LABEL));
        ATTRIBUTE_MAP.put(VAR_VAR, PhpColorPageHighlighter.phpScript(PhpHighlightingData.VAR_VAR));
        ATTRIBUTE_MAP.put(TokenType.BAD_CHARACTER, PhpColorPageHighlighter.phpScript(PhpHighlightingData.BAD_CHARACTER));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeMap";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sample";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/highlighter/PhpColorPageHighlighter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/highlighter/PhpColorPageHighlighter";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenHighlights";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "phpScript";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeMap";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class HighlightingType
    extends IElementType {
        HighlightingType(@NotNull @NonNls String debugName) {
            if (debugName == null) {
                HighlightingType.$$$reportNull$$$0(0);
            }
            super(debugName, (Language)PhpLanguage.INSTANCE, true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "com/jetbrains/php/lang/highlighter/PhpColorPageHighlighter$HighlightingType", "<init>"));
        }
    }

    private static class TokenPattern {
        public String tokenText;
        public String patternText;
        public IElementType mappedType;

        TokenPattern(String tokenText, String patternText, IElementType mappedType) {
            this.tokenText = tokenText;
            this.patternText = patternText;
            this.mappedType = mappedType;
        }
    }

    private static class ColorPageLexer
    extends PhpHighlightingLexer {
        private final Map<Integer, IElementType> myTypeMap;

        private ColorPageLexer(Map<Integer, IElementType> map) {
            this.myTypeMap = map;
        }

        @Override
        public IElementType getTokenType() {
            int tokenOffset = this.getTokenStart();
            if (this.myTypeMap.containsKey(tokenOffset)) {
                return this.myTypeMap.get(tokenOffset);
            }
            return super.getTokenType();
        }
    }
}

