/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.probablyBug;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpConstantDeclarationInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.quickfix.PhpRemoveStatementQuickFix;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;

public class PhpConstantReassignmentInspection
extends PhpInspection {
    private static final String DESCRIPTION_TEMPLATE = "Constant reassignment";
    private static final LocalQuickFix[] FIXES = new LocalQuickFix[]{new PhpRemoveStatementQuickFix("constant assignment", (Condition<PsiElement>)Constant.INSTANCEOF, PhpTokenTypes.opCOMMA)};

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpConstantReassignmentInspection.$$$reportNull$$$0(0);
        }
        PhpElementVisitor phpElementVisitor = new PhpElementVisitor(){

            public void visitPhpConstant(Constant constant) {
                PhpInstruction[] instructions;
                PsiElement namePsiElement = constant.getNameIdentifier();
                if (namePsiElement == null) {
                    return;
                }
                PhpScopeHolder scopeHolder = PhpPsiUtil.getScopeHolder((PsiElement)constant);
                if (scopeHolder == null) {
                    return;
                }
                for (PhpInstruction instruction : instructions = scopeHolder.getControlFlow().getInstructions()) {
                    if (!(instruction instanceof PhpConstantDeclarationInstruction) || constant != ((PhpConstantDeclarationInstruction)instruction).getConstant()) continue;
                    this.analyseConstant(instruction, namePsiElement, constant.getFQN());
                }
            }

            private void analyseConstant(@NotNull PhpInstruction instruction, final @NotNull PsiElement namePsiElement, final String constantFqn) {
                if (instruction == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (namePsiElement == null) {
                    1.$$$reportNull$$$0(1);
                }
                PhpInstructionProcessor processor = new PhpInstructionProcessor(){

                    public boolean processConstantDeclarationInstruction(PhpConstantDeclarationInstruction internal) {
                        if (PhpLangUtil.equalsConstantNames(constantFqn, internal.getConstant().getFQN())) {
                            holder.registerProblem(namePsiElement, PhpConstantReassignmentInspection.DESCRIPTION_TEMPLATE, FIXES);
                            return false;
                        }
                        return true;
                    }
                };
                PhpControlFlowUtil.processPredecessorsIgnoreInitialBackEdges(instruction, false, processor);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "instruction";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "namePsiElement";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/php/lang/inspections/probablyBug/PhpConstantReassignmentInspection$1";
                objectArray[2] = "analyseConstant";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (phpElementVisitor == null) {
            PhpConstantReassignmentInspection.$$$reportNull$$$0(1);
        }
        return phpElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/probablyBug/PhpConstantReassignmentInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/probablyBug/PhpConstantReassignmentInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

