/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions.stringDoc;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import org.jetbrains.annotations.NotNull;

public class PhpHeredocToStringIntention
extends PsiElementBaseIntentionAction {
    public static final String FAMILY_NAME = "Convert HEREDOC/NOWDOC to string literal";
    public static final String HEREDOC_NAME = "Convert HEREDOC to string literal";
    public static final String NOWDOC_NAME = "Convert NOWDOC to string literal";
    static final char SINGLE_QUOTE = '\'';
    static final char DOUBLE_QUOTE = '\"';

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        ASTNode parentNode;
        PsiElement parent;
        if (project == null) {
            PhpHeredocToStringIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            PhpHeredocToStringIntention.$$$reportNull$$$0(1);
        }
        if ((parent = element.getParent()) instanceof StringLiteralExpression && (parentNode = parent.getNode()) != null && parentNode.getElementType() == PhpElementTypes.HEREDOC) {
            ASTNode[] elements = parentNode.getChildren(null);
            char quoteType = PhpHeredocToStringIntention.isNowdoc(parent) ? (char)'\'' : '\"';
            String binary = "";
            String text = parent.getFirstChild().getText();
            if (text.startsWith("b") || text.startsWith("B")) {
                binary = text.substring(0, 1);
            }
            String content = PhpHeredocToStringIntention.getEscapedContent(elements, quoteType);
            StringLiteralExpression literal = PhpPsiElementFactory.createFirstFromText(project, StringLiteralExpression.class, "$a = " + binary + quoteType + content + quoteType);
            if (literal != null) {
                parent.replace((PsiElement)literal);
            }
        }
    }

    public static String getEscapedContent(ASTNode[] elements, char quoteType) {
        String answer = "";
        for (ASTNode it : elements) {
            if (it.getElementType() == PhpTokenTypes.HEREDOC_START || it.getElementType() == PhpTokenTypes.HEREDOC_END) continue;
            answer = it.getElementType() != PhpStubElementTypes.VARIABLE ? answer + PhpHeredocToStringIntention.escapeSymbols(it.getText(), quoteType) : answer + it.getText();
        }
        return answer;
    }

    public static String escapeSymbols(String arg, char quoteType) {
        if (quoteType == '\"') {
            arg = arg.replace("\\\\", "\\");
        }
        char[] chars = arg.toCharArray();
        StringBuilder answer = new StringBuilder();
        for (char it : chars) {
            if (it == quoteType) {
                answer.append('\\');
            }
            if (it == '\\') {
                answer.append('\\');
            }
            answer.append(it);
        }
        return answer.toString();
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            PhpHeredocToStringIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            PhpHeredocToStringIntention.$$$reportNull$$$0(3);
        }
        if (!PhpWorkaroundUtil.isIntentionAvailable(element)) {
            return false;
        }
        ASTNode node = element.getNode();
        if (node == null) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof StringLiteralExpression && PhpPsiUtil.isOfType(parent, PhpElementTypes.HEREDOC)) {
            if (PhpHeredocToStringIntention.isNowdoc(parent)) {
                this.setText(NOWDOC_NAME);
            } else {
                this.setText(HEREDOC_NAME);
            }
            return true;
        }
        return false;
    }

    public static boolean isNowdoc(@NotNull PsiElement docBegin) {
        PsiElement docStart;
        if (docBegin == null) {
            PhpHeredocToStringIntention.$$$reportNull$$$0(4);
        }
        if (PhpPsiUtil.isOfType(docStart = docBegin.getFirstChild(), PhpTokenTypes.HEREDOC_START)) {
            String docStartText = docStart.getText();
            int counter = 3;
            if (docStartText.startsWith("b") || docStartText.startsWith("B")) {
                ++counter;
            }
            while (counter < docStartText.length() && docStartText.charAt(counter) == ' ') {
                ++counter;
            }
            return counter < docStartText.length() && docStartText.charAt(counter) == '\'';
        }
        return false;
    }

    @NotNull
    public String getFamilyName() {
        if (FAMILY_NAME == null) {
            PhpHeredocToStringIntention.$$$reportNull$$$0(5);
        }
        return FAMILY_NAME;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docBegin";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/intentions/stringDoc/PhpHeredocToStringIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/intentions/stringDoc/PhpHeredocToStringIntention";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isNowdoc";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

