/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phpunit;

import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.ide.scratch.ScratchFileType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocRef;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamespaceReference;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpUnitUtil {
    private static final NotificationGroup NOTIFICATION_GROUP = NotificationGroup.toolWindowGroup((String)"PHPUnit", (String)ToolWindowId.RUN, (boolean)false);
    private static final String PHPUNIT_TEST_CLASS = "PHPUnit_Framework_TestCase";
    private static final String PHPUNIT6_TEST_CLASS_FQN = "\\PHPUnit\\Framework\\TestCase";
    private static final String PHPUNIT_SUITE_METHOD = "suite";
    private static final String PHPUNIT_TEST_METHOD_PREFIX = "test";
    private static final String PHPUNIT_TEST_METHOD_ANNOTATION = "@test";
    private static final String TAG_PHPUNIT = "phpunit";
    public static final String PHPUNIT_XML_DIST = "phpunit.xml.dist";
    public static final String PHPUNIT_XML = "phpunit.xml";
    public static final String PHPUNIT = "phpunit";
    public static final String XML = "xml";
    public static final String GET_PHPUNIT_PHAR_URL = "https://phar.phpunit.de/phpunit.phar";
    public static final String PHPUNIT_PHAR = "phpunit.phar";
    public static final Condition<PhpClass> IS_TEST_CLASS_ALLOW_SUITE_CONDITION = phpClass -> PhpUnitUtil.isTestClass(phpClass);
    public static final String TOOL_NAME = "PHPUnit";
    public static final String CODE_COVERAGE_IGNORE_TAG = "@codeCoverageIgnore";

    private PhpUnitUtil() {
    }

    @NotNull
    public static Collection<PhpClass> getAllPhpTestClassesInFile(@NotNull PhpFile phpFile) {
        if (phpFile == null) {
            PhpUnitUtil.$$$reportNull$$$0(0);
        }
        Collection<PhpClass> collection = PhpPsiUtil.findClasses(phpFile, IS_TEST_CLASS_ALLOW_SUITE_CONDITION);
        if (collection == null) {
            PhpUnitUtil.$$$reportNull$$$0(1);
        }
        return collection;
    }

    @Nullable
    public static PhpClass findClassByFQNInFile(@NotNull String fqn, @NotNull PsiFile psiFile, @NotNull Project project) {
        if (fqn == null) {
            PhpUnitUtil.$$$reportNull$$$0(2);
        }
        if (psiFile == null) {
            PhpUnitUtil.$$$reportNull$$$0(3);
        }
        if (project == null) {
            PhpUnitUtil.$$$reportNull$$$0(4);
        }
        if (psiFile instanceof PhpFile && FileTypeManager.getInstance().isFileOfType(psiFile.getVirtualFile(), (FileType)ScratchFileType.INSTANCE)) {
            return PhpPsiUtil.findClass((PhpFile)psiFile, (Condition<? super PhpClass>)((Condition)aClass -> {
                if (fqn == null) {
                    PhpUnitUtil.$$$reportNull$$$0(33);
                }
                return PhpLangUtil.equalsClassNames(aClass.getPresentableFQN(), fqn);
            }));
        }
        for (PhpClass phpClass : PhpIndex.getInstance((Project)project).getClassesByFQN(fqn)) {
            PsiFile containingFile = phpClass.getContainingFile();
            if (containingFile != psiFile) continue;
            return phpClass;
        }
        return null;
    }

    @NotNull
    public static PhpClass getAndCheckClass(@Nullable String classFQN, @NotNull PsiFile file, @NotNull Project project) throws RuntimeConfigurationError {
        PhpClass phpClass;
        if (file == null) {
            PhpUnitUtil.$$$reportNull$$$0(5);
        }
        if (project == null) {
            PhpUnitUtil.$$$reportNull$$$0(6);
        }
        if (classFQN != null && (phpClass = PhpUnitUtil.findClassByFQNInFile(classFQN, file, project)) != null && PhpUnitUtil.isTestClass(phpClass)) {
            PhpClass phpClass2 = phpClass;
            if (phpClass2 == null) {
                PhpUnitUtil.$$$reportNull$$$0(7);
            }
            return phpClass2;
        }
        throw new RuntimeConfigurationError(PhpBundle.message("validation.value.is.not.specified.or.invalid", "Test class"));
    }

    public static Method getAndCheckMethod(@Nullable String methodName, @NotNull PhpClass testClass) throws RuntimeConfigurationError {
        if (testClass == null) {
            PhpUnitUtil.$$$reportNull$$$0(8);
        }
        if (StringUtil.isEmptyOrSpaces((String)methodName)) {
            throw new RuntimeConfigurationError(PhpBundle.message("php.method.name.empty", new Object[0]));
        }
        Method method = testClass.findMethodByName((CharSequence)methodName);
        if (method == null) {
            throw new RuntimeConfigurationError(PhpBundle.message("php.method.not.found", methodName, testClass.getName()));
        }
        if (!PhpUnitUtil.isTestMethod(testClass, method)) {
            throw new RuntimeConfigurationError(PhpBundle.message("php.not.test.method", methodName, testClass.getName()));
        }
        return method;
    }

    public static boolean isTestClass(@NotNull PhpClass phpClass) {
        if (phpClass == null) {
            PhpUnitUtil.$$$reportNull$$$0(9);
        }
        return PhpUnitUtil.isTestClass(phpClass, true);
    }

    public static boolean isTestClass(@NotNull PhpClass phpClass, boolean allowSuite) {
        Method method;
        if (phpClass == null) {
            PhpUnitUtil.$$$reportNull$$$0(10);
        }
        if (phpClass.isAbstract() || phpClass.isInterface() || phpClass.isAnonymous()) {
            return false;
        }
        if (allowSuite && PhpUnitUtil.isSuiteMethod(method = phpClass.findMethodByName((CharSequence)PHPUNIT_SUITE_METHOD))) {
            return true;
        }
        return PhpUnitUtil.extendsRootTestClass(phpClass);
    }

    public static boolean isRunnableTestClass(@NotNull PhpClass phpClass) {
        if (phpClass == null) {
            PhpUnitUtil.$$$reportNull$$$0(11);
        }
        return phpClass.isAbstract() ? PhpUnitUtil.extendsRootTestClass(phpClass) && PhpUnitUtil.getRealTestClass(phpClass) != null : PhpUnitUtil.isTestClass(phpClass);
    }

    public static boolean extendsRootTestClass(@NotNull PhpClass phpClass) {
        if (phpClass == null) {
            PhpUnitUtil.$$$reportNull$$$0(12);
        }
        Ref isTestClassRef = new Ref((Object)false);
        PhpClassHierarchyUtils.processSuperClasses((PhpClass)phpClass, (boolean)true, (boolean)true, aClass -> {
            if (PhpUnitUtil.isRootTestClass(aClass)) {
                isTestClassRef.set((Object)true);
            }
            return (Boolean)isTestClassRef.get() == false;
        });
        return (Boolean)isTestClassRef.get();
    }

    public static boolean isRootTestClass(PhpClass aClass) {
        String superFqn = aClass.getSuperFQN();
        if (superFqn != null) {
            if (PhpLangUtil.equalsClassNames(PHPUNIT6_TEST_CLASS_FQN, superFqn)) {
                return true;
            }
            String superName = PhpLangUtil.toShortName(superFqn);
            return PhpLangUtil.equalsClassNames(PHPUNIT_TEST_CLASS, superName);
        }
        return false;
    }

    private static boolean canBeTestMethod(@NotNull Method method) {
        if (method == null) {
            PhpUnitUtil.$$$reportNull$$$0(13);
        }
        return !method.isAbstract() && method.getAccess().isPublic();
    }

    private static boolean isSuiteMethod(@Nullable Method method) {
        return method != null && PhpLangUtil.equalsMethodNames(PHPUNIT_SUITE_METHOD, method.getNameCS()) && PhpUnitUtil.canBeTestMethod(method) && method.isStatic();
    }

    @Nullable
    public static PhpClass getRealTestClass(@NotNull PhpClass containingClass) {
        if (containingClass == null) {
            PhpUnitUtil.$$$reportNull$$$0(14);
        }
        for (PhpClass clazz : PhpClassHierarchyUtils.getDirectSubclasses((PhpClass)containingClass)) {
            if (!PhpUnitUtil.isTestClass(clazz, false)) continue;
            return clazz;
        }
        return null;
    }

    public static boolean isTestMethod(@NotNull PhpClass containingClass, @NotNull Method method) {
        if (containingClass == null) {
            PhpUnitUtil.$$$reportNull$$$0(15);
        }
        if (method == null) {
            PhpUnitUtil.$$$reportNull$$$0(16);
        }
        if (PhpUnitUtil.canBeTestMethod(method)) {
            return PhpUnitUtil.isTestMethodInternal(containingClass, method);
        }
        return false;
    }

    public static boolean isTestMethod(@NotNull Method method) {
        if (method == null) {
            PhpUnitUtil.$$$reportNull$$$0(17);
        }
        if (PhpUnitUtil.canBeTestMethod(method)) {
            PhpClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return false;
            }
            return PhpUnitUtil.isTestMethodInternal(containingClass, method);
        }
        return false;
    }

    private static boolean isTestMethodInternal(@NotNull PhpClass containingClass, @NotNull Method method) {
        if (containingClass == null) {
            PhpUnitUtil.$$$reportNull$$$0(18);
        }
        if (method == null) {
            PhpUnitUtil.$$$reportNull$$$0(19);
        }
        if (containingClass.isAbstract()) {
            PhpClass realTestClass = PhpUnitUtil.getRealTestClass(containingClass);
            if (realTestClass == null) {
                return false;
            }
            containingClass = realTestClass;
        }
        if (PhpUnitUtil.isTestClass(containingClass)) {
            if (StringUtil.startsWith((CharSequence)method.getNameCS(), (CharSequence)PHPUNIT_TEST_METHOD_PREFIX) || PhpUnitUtil.isSuiteMethod(method)) {
                return true;
            }
            PhpDocComment docComment = method.getDocComment();
            if (docComment != null && docComment.getTagElementsByName(PHPUNIT_TEST_METHOD_ANNOTATION).length > 0) {
                return true;
            }
        }
        return false;
    }

    public static boolean isPhpUnitConfigurationFileName(@NotNull String fileName) {
        if (fileName == null) {
            PhpUnitUtil.$$$reportNull$$$0(20);
        }
        return fileName.equalsIgnoreCase(PHPUNIT_XML) || fileName.equalsIgnoreCase(PHPUNIT_XML_DIST) || fileName.contains("phpunit") && fileName.contains(XML);
    }

    public static boolean isPhpUnitConfigurationFile(@NotNull PsiFile psiFile) {
        XmlFile xmlFile;
        XmlTag rootTag;
        if (psiFile == null) {
            PhpUnitUtil.$$$reportNull$$$0(21);
        }
        return psiFile instanceof XmlFile && (rootTag = (xmlFile = (XmlFile)psiFile).getRootTag()) != null && rootTag.getName().equalsIgnoreCase("phpunit");
    }

    @Nullable
    public static PhpClass findTestClass(@NotNull PhpFile phpFile) {
        if (phpFile == null) {
            PhpUnitUtil.$$$reportNull$$$0(22);
        }
        return PhpPsiUtil.findClass(phpFile, IS_TEST_CLASS_ALLOW_SUITE_CONDITION);
    }

    public static boolean isPhpUnitTestFileName(@NotNull String fileNameWithoutExtension) {
        if (fileNameWithoutExtension == null) {
            PhpUnitUtil.$$$reportNull$$$0(23);
        }
        return fileNameWithoutExtension.equalsIgnoreCase("AllTests") || fileNameWithoutExtension.contains("Test");
    }

    public static boolean isPhpUnitTestFile(@NotNull PsiFile psiFile) {
        PhpFile phpFile;
        VirtualFile virtualFile;
        if (psiFile == null) {
            PhpUnitUtil.$$$reportNull$$$0(24);
        }
        return psiFile instanceof PhpFile && (virtualFile = (phpFile = (PhpFile)psiFile).getVirtualFile()) != null && PhpUnitUtil.isPhpUnitTestFileName(virtualFile.getNameWithoutExtension()) && PhpUnitUtil.findTestClass(phpFile) != null;
    }

    public static void showWarningBalloon(@Nullable Project project, @NotNull String title, @NotNull String text, @Nullable NotificationListener listener) {
        if (title == null) {
            PhpUnitUtil.$$$reportNull$$$0(25);
        }
        if (text == null) {
            PhpUnitUtil.$$$reportNull$$$0(26);
        }
        NOTIFICATION_GROUP.createNotification(title, text, NotificationType.WARNING, listener).notify(project);
    }

    public static void showRunToolWindowError(@Nullable Project project, @NotNull String title, @NotNull String text, @Nullable NotificationListener listener) {
        if (title == null) {
            PhpUnitUtil.$$$reportNull$$$0(27);
        }
        if (text == null) {
            PhpUnitUtil.$$$reportNull$$$0(28);
        }
        NOTIFICATION_GROUP.createNotification(title, text, NotificationType.ERROR, listener).notify(project);
    }

    @NotNull
    public static Pair<String, String> getClassFqnAndMethodName(@Nullable PhpDocRef dataProvider, @NotNull String testClassNamespace) {
        if (testClassNamespace == null) {
            PhpUnitUtil.$$$reportNull$$$0(29);
        }
        if (dataProvider != null) {
            PsiElement methodIdentifier;
            PsiElement child = dataProvider.getLastChild();
            PsiElement psiElement = methodIdentifier = PhpPsiUtil.isOfType(child, PhpDocTokenTypes.DOC_IDENTIFIER) ? child : PhpPsiUtil.findPrevSiblingOfAnyType(child, PhpDocTokenTypes.DOC_IDENTIFIER);
            if (methodIdentifier != null) {
                PsiElement classIdentifier = PhpPsiUtil.findPrevSiblingOfAnyType(methodIdentifier, PhpDocTokenTypes.DOC_IDENTIFIER);
                Pair pair = Pair.create((Object)PhpUnitUtil.getClassFqn(classIdentifier, testClassNamespace), (Object)methodIdentifier.getText());
                if (pair == null) {
                    PhpUnitUtil.$$$reportNull$$$0(30);
                }
                return pair;
            }
        }
        Pair pair = Pair.empty();
        if (pair == null) {
            PhpUnitUtil.$$$reportNull$$$0(31);
        }
        return pair;
    }

    @Nullable
    private static String getClassFqn(@Nullable PsiElement classIdentifier, @NotNull String testClassNamespace) {
        if (testClassNamespace == null) {
            PhpUnitUtil.$$$reportNull$$$0(32);
        }
        if (classIdentifier == null) {
            return null;
        }
        String className = classIdentifier.getText();
        PhpNamespaceReference namespaceReference = (PhpNamespaceReference)ObjectUtils.tryCast((Object)classIdentifier.getPrevSibling(), PhpNamespaceReference.class);
        String namespace = namespaceReference != null ? namespaceReference.getFullName() : testClassNamespace;
        return PhpLangUtil.concat(PhpLangUtil.toFQN(namespace), PhpLangUtil.toFQN(className));
    }

    @Nullable
    public static String getDefaultCoveredClassName(@Nullable PhpClass clazz) {
        PhpDocComment docComment = clazz != null ? clazz.getDocComment() : null;
        PhpDocTag defaultCoveredClassTag = docComment != null ? (PhpDocTag)ArrayUtil.getFirstElement((Object[])docComment.getTagElementsByName("@coversDefaultClass")) : null;
        PhpReference reference = (PhpReference)PhpPsiUtil.getChildByCondition((PsiElement)defaultCoveredClassTag, (Condition<? super PsiElement>)PhpReference.INSTANCEOF);
        return reference != null ? reference.getFQN() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 7: 
            case 30: 
            case 31: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 7: 
            case 30: 
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpFile";
                break;
            }
            case 1: 
            case 7: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/phpunit/PhpUnitUtil";
                break;
            }
            case 2: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 3: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testClass";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpClass";
                break;
            }
            case 13: 
            case 16: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 14: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingClass";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileNameWithoutExtension";
                break;
            }
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testClassNamespace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/phpunit/PhpUnitUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllPhpTestClassesInFile";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAndCheckClass";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassFqnAndMethodName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAllPhpTestClassesInFile";
                break;
            }
            case 1: 
            case 7: 
            case 30: 
            case 31: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findClassByFQNInFile";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAndCheckClass";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getAndCheckMethod";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isTestClass";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isRunnableTestClass";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "extendsRootTestClass";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "canBeTestMethod";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getRealTestClass";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isTestMethod";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isTestMethodInternal";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isPhpUnitConfigurationFileName";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isPhpUnitConfigurationFile";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findTestClass";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isPhpUnitTestFileName";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isPhpUnitTestFile";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "showWarningBalloon";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "showRunToolWindowError";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getClassFqnAndMethodName";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getClassFqn";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findClassByFQNInFile$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 7: 
            case 30: 
            case 31: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

