/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql;

import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.connection.statements.ParameterizedStatementDecoration;
import com.intellij.database.dataSource.connection.statements.ReusableSmartStatement;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.connection.statements.StandardResultsProcessors;
import com.intellij.database.dataSource.connection.statements.StatementParameters;
import com.intellij.database.dialects.mssql.MssqlDialect;
import com.intellij.database.dialects.mssql.TsqlDefinitionProviderBase;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import com.intellij.util.PairConsumer;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MsDefinitionProvider
extends TsqlDefinitionProviderBase {
    @Override
    public boolean isSupported(@NotNull DasObject object) {
        ObjectKind kind;
        if (object == null) {
            MsDefinitionProvider.$$$reportNull$$$0(0);
        }
        return (kind = object.getKind()) == ObjectKind.VIEW || kind == ObjectKind.ROUTINE || kind == ObjectKind.TRIGGER;
    }

    @Override
    protected void fetchSources(@NotNull Iterable<? extends DasObject> objects, @NotNull DatabaseConnection connection2, @NotNull PairConsumer<DasObject, Object> consumer2) {
        if (objects == null) {
            MsDefinitionProvider.$$$reportNull$$$0(1);
        }
        if (connection2 == null) {
            MsDefinitionProvider.$$$reportNull$$$0(2);
        }
        if (consumer2 == null) {
            MsDefinitionProvider.$$$reportNull$$$0(3);
        }
        MssqlDialect dialect = MssqlDialect.INSTANCE;
        try (ReusableSmartStatement<ParameterizedStatementDecoration> statement = SmartStatements.poweredBy(connection2).parameterized().reuse("select object_definition(object_id(?))");){
            for (DasObject dasObject : objects) {
                String name = dialect.quoteIdentifier(DasUtil.getSchema((DasObject)dasObject), true, false) + "." + dialect.quoteIdentifier(dasObject.getName(), true, false);
                ParameterizedStatementDecoration data = new StatementParameters().text(name).asDecoration();
                consumer2.consume((Object)dasObject, statement.execute(data, StandardResultsProcessors.FIRST_STRING).any());
            }
        }
    }

    @Override
    @Nullable
    protected String getCurrentDb(@NotNull DatabaseConnection connection2) throws SQLException {
        MssqlDialect dialect;
        ObjectPath current;
        if (connection2 == null) {
            MsDefinitionProvider.$$$reportNull$$$0(4);
        }
        return (current = SearchPath.getCurrent((SearchPath)(dialect = MssqlDialect.INSTANCE).tryToLoadSearchPath(connection2.getConnectionPoint().getDataSource(), connection2))) == null ? null : current.getName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/dialects/mssql/MsDefinitionProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isSupported";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "fetchSources";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getCurrentDb";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

