/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.intellij.database.access.ConnectionProvider;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.psi.DbColumn;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbElementImpl;
import com.intellij.database.psi.DbTable;
import com.intellij.database.run.ui.DataGridDocumentationProvider;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.CharOut;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.lang.Language;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbTableImpl
extends DbElementImpl<DasTable, DbElement>
implements DbTable {
    protected DbTableImpl(DbElement parent2, @NotNull DasTable delegate) {
        if (delegate == null) {
            DbTableImpl.$$$reportNull$$$0(0);
        }
        super(parent2, delegate);
    }

    @Override
    @NotNull
    public StringBuilder getDocumentation() {
        DdlBuilder.Colored colored = this.createDocHeaderColored();
        StringBuilder sb = colored.cast(StringBuilder.class);
        boolean skipDDL = this.appendDefinition(sb);
        ObjectKind kind = this.getKind();
        if (kind != ObjectKind.SYNONYM && kind != ObjectKind.SEQUENCE && !skipDDL) {
            colored.plain("<br>").plain("<!-- async-doc-cut -->").plain("<code><pre>");
            colored.comment("auto-generated definition").newLine();
            colored.plain(this.sql2Html(DatabaseEditorHelper.generateDefinition(this, new StringBuilder())));
            colored.plain("</pre></code>");
        }
        if (DbImplUtil.isDataTable((DasTable)this) || !skipDDL && DatabaseEditorHelper.isRawDefinitionAvailable(this)) {
            this.scheduleAsyncDocumentationUpdate(sb, (out, conn) -> this.loadSlowDocumentationInner(skipDDL, out, conn));
        }
        StringBuilder stringBuilder = sb;
        if (stringBuilder == null) {
            DbTableImpl.$$$reportNull$$$0(1);
        }
        return stringBuilder;
    }

    @Override
    @NotNull
    protected StringBuilder createDocHeaderDefault() {
        StringBuilder sb = super.createDocHeaderDefault();
        DasTable delegate = (DasTable)this.getDelegate();
        if (delegate instanceof BasicElement) {
            DbImplUtil.getModelHelper(this.getDataSource().getDbms()).docAppendInfo((BasicElement)delegate, sb);
        }
        StringBuilder stringBuilder = sb;
        if (stringBuilder == null) {
            DbTableImpl.$$$reportNull$$$0(2);
        }
        return stringBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSlowDocumentationInner(boolean skipDDL, @NotNull CharOut sb, @NotNull ConnectionProvider provider) throws Exception {
        if (sb == null) {
            DbTableImpl.$$$reportNull$$$0(3);
        }
        if (provider == null) {
            DbTableImpl.$$$reportNull$$$0(4);
        }
        if (DbImplUtil.isDataTable((DasTable)this)) {
            Map<Object, Object> infoMap = Collections.emptyMap();
            try {
                infoMap = DbImplUtil.tryLoadTableInfo(provider, this);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!skipDDL && DatabaseEditorHelper.isRawDefinitionAvailable(this)) {
                sb.append("<b>Definition:</b><br><code><pre>");
                StringBuilder builder = new StringBuilder();
                DatabaseEditorHelper.loadDefinition(provider, this, builder);
                sb.append(DbSqlUtil.sql2Html(this.getProject(), (Language)DbSqlUtil.getSqlDialect(this), builder));
                sb.append("</pre></code>");
            }
            int previewRows = DatabaseSettings.getSettings().getPreviewRows();
            DdlBuilder builder = DbImplUtil.createSelectAllQuery((DasTable)this, this.getDataSource().getDbms(), (DasDataSource)this.getDataSource(), previewRows);
            String tableQuery = builder.getStatement();
            sb.append("<br><b>Rows:</b> ~").append(ObjectUtils.notNull((Object)infoMap.get("rows"), (Object)"0").toString()).append(DataGridDocumentationProvider.getCountCommand(false)).append("<br>");
            for (String string : infoMap.keySet()) {
                Object obj = infoMap.get(string);
                String s = obj == null ? null : String.valueOf(obj);
                if (StringUtil.isEmptyOrSpaces((String)s) || "rows".equals(string)) continue;
                sb.append("<b>" + string + ":</b> " + s + "<br>");
            }
            if (previewRows > 0) {
                sb.append("<br>");
                long curLength = sb.length();
                try {
                    if (provider.acquire()) {
                        DbImplUtil.tryLoadFirstNRows("<b>First %d rows:</b><br><br>", provider.getConnection(), tableQuery, sb, previewRows);
                    }
                }
                finally {
                    provider.release();
                }
                if (sb.length() == curLength) {
                    sb.append("<b>").append(StringUtil.capitalize((String)this.getTypeName())).append(" is empty</b><br>");
                }
            }
        }
    }

    public boolean isSystem() {
        return ((DasTable)this.myDelegate).isSystem();
    }

    public boolean isTemporary() {
        return ((DasTable)this.myDelegate).isTemporary();
    }

    @NotNull
    public Set<DasColumn.Attribute> getColumnAttrs(@Nullable DasColumn columnInfo) {
        Set set = ((DasTable)this.myDelegate).getColumnAttrs(columnInfo instanceof DbColumn ? (DasColumn)((DbColumn)columnInfo).getDelegate() : columnInfo);
        if (set == null) {
            DbTableImpl.$$$reportNull$$$0(5);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/psi/DbTableImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/psi/DbTableImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocumentation";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createDocHeaderDefault";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnAttrs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadSlowDocumentationInner";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

